<div class="container-fluid py-4">
  <div class="card shadow-sm border-0 mb-4">
    <div class="card-body">
      <form class="row g-3" method="get">
        <div class="col-md-3">
          <label class="form-label">Start Date</label>
          <input type="date" name="start_date" value="<?= $start_date ?>" class="form-control">
        </div>
        <div class="col-md-3">
          <label class="form-label">End Date</label>
          <input type="date" name="end_date" value="<?= $end_date ?>" class="form-control">
        </div>
        <div class="col-md-3">
          <label class="form-label">Sport</label>
          <select name="sport" class="form-control">
            <option value="">All Sports</option>
            <?php foreach($sports as $s): ?>
              <option value="<?= $s->id ?>" <?= $sport==$s->id ? 'selected':'' ?>><?= $s->name ?></option>
            <?php endforeach; ?>
          </select>
        </div>
        <div class="col-md-2">
          <label class="form-label">Status</label>
          <select name="status" class="form-control">
            <option value="">All</option>
            <option value="confirmed" <?= $status=='confirmed'?'selected':'' ?>>Confirmed</option>
            <option value="pending" <?= $status=='pending'?'selected':'' ?>>Pending</option>
            <option value="cancelled" <?= $status=='cancelled'?'selected':'' ?>>Cancelled</option>
          </select>
        </div>
        <div class="col-md-1 d-flex align-items-end">
          <button type="submit" class="btn btn-primary w-100"><i class="fa fa-search"></i></button>
        </div>
      </form>
    </div>
  </div>

  <!-- Summary -->
  <div class="row g-4 mb-4">
    <div class="col-md-6">
      <div class="card shadow-sm border-0 h-100">
        <div class="card-body">
          <h6 class="text-muted">Total Bookings</h6>
          <h3 class="fw-bold"><?= $summary->total_bookings ?? 0 ?></h3>
        </div>
      </div>
    </div>
    <div class="col-md-6">
      <div class="card shadow-sm border-0 h-100">
        <div class="card-body">
          <h6 class="text-muted">Total Revenue</h6>
          <h3 class="fw-bold">₹<?= number_format($summary->total_revenue ?? 0) ?></h3>
        </div>
      </div>
    </div>
  </div>

  <!-- Report Table -->
  <div class="card shadow-sm border-0">
    <div class="card-header bg-white border-0 d-flex justify-content-between align-items-center">
      <h5 class="card-title mb-0">Report</h5>
      <div>
        <a href="#" class="btn btn-sm btn-outline-success"><i class="bi bi-file-earmark-excel"></i> Export Excel</a>
        <a href="#" class="btn btn-sm btn-outline-danger"><i class="bi bi-file-earmark-pdf"></i> Export PDF</a>
      </div>
    </div>
    <div class="table-responsive">
      <table class="table align-middle mb-0">
        <thead class="table-light">
          <tr>
            <th>Booking No</th>
            <th>Customer</th>
            <th>Sport</th>
            <th>Pitch</th>
            <th>Date</th>
            <th>Time</th>
            <th>Amount</th>
            <th>Status</th>
          </tr>
        </thead>
        <tbody>
          <?php if(count($report) > 0): ?>
            <?php foreach($report as $r): ?>
              <tr>
                <td>#<?= $r->booking_no ?></td>
                <td><?= $r->customer_name ?> <br><small><?= $r->email ?></small></td>
                <td><?= $r->sport_name ?></td>
                <td><?= $r->pitch_name ?></td>
                <td><?= date('M d, Y', strtotime($r->booking_date)) ?></td>
                <td><?= $r->start_time ?> - <?= $r->end_time ?></td>
                <td>₹<?= $r->total_price ?></td>
                <td>
                  <?php if($r->status=='confirmed'): ?>
                    <span class="badge bg-success">Confirmed</span>
                  <?php elseif($r->status=='pending'): ?>
                    <span class="badge bg-warning">Pending</span>
                  <?php else: ?>
                    <span class="badge bg-danger">Cancelled</span>
                  <?php endif; ?>
                </td>
              </tr>
            <?php endforeach; ?>
          <?php else: ?>
            <tr><td colspan="8" class="text-center text-muted">No data found</td></tr>
          <?php endif; ?>
        </tbody>
      </table>
    </div>
  </div>
</div>
