<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/jquery-confirm/3.3.0/jquery-confirm.min.css">
<script src="https://cdnjs.cloudflare.com/ajax/libs/jquery-confirm/3.3.0/jquery-confirm.min.js"></script>
<!-- TOP Nav Bar END -->
<div class="container-fluid">
   <div class="row">
      <div class="col-sm-12">
         <div class="iq-card">
            <div class="iq-card-header d-flex justify-content-between">
               <div class="iq-header-title">
                  <h4 class="card-title">Pitches List</h4>
               </div>
               <span class="table-add float-right mb-3 mr-2">
                  <a href="<?php echo base_url(); ?>Pitches/add" class="btn btn-sm iq-bg-success" ><i
                     class="ri-add-fill"><span class="pl-1">Add New</span></i>
                  </a>
                  </span>
            </div>
            <div class="iq-card-body">
             <div id="table" class="table-editable">
            <table id="myTable" class="display table" style="width:100%">
              <thead>
                <tr>
                    <th>Sl No.</th>
                    <th>Sport Name</th>
                    <th>Name</th>
                    <th>Step (min)</th>
                    <th>Manage</th>
                    <th>Action</th>
                </tr>
              </thead>
              <tbody>
                <?php  
                $start=0;
                for($i=0;$i<count($recordSet);$i++)
                   { $start++;

                ?>
                <tr>
                    <td scope="row"><?php echo $start; ?></td>
                    <td><?php echo $recordSet[$i]['sport_name'];?></td>
                    <td><?php echo $recordSet[$i]['name'];?></td>
                    <td><?php echo $recordSet[$i]['slot_step_minutes']; ?></td>
                    
                    <td>
                        <button class="btn btn-sm btn-primary manage-hours" 
                        data-id="<?= $recordSet[$i]['id']; ?>"
                        data-name="<?= $recordSet[$i]['name']; ?>">
                            Manage Hours
                        </button> 
                        <a class="btn btn-warning" href="<?= site_url('Pitches/rate_cards/'.$recordSet[$i]['id']) ?>">Rates</a>
                        <!-- <a href="#" class="view" title="view"><i class="fa fa-eye" aria-hidden="true"></i> </a> -->

                    </td>
                    <td>
                        <a href="<?php echo base_url().'Pitches/Edit/'.$recordSet[$i]['id']; ?>" class="edit" title="Edit"><i class="fa fa-pencil" aria-hidden="true"></i>   </a>
                        <a href="javascript:void(0)"  onclick="delete_function(<?php echo $recordSet[$i]['id']; ?>);" class="delete remScnt" title="Delete"><i class="fa fa-trash" style="color:red;" aria-hidden="true" title="Delete"></i> </a>

                    </td>
                </tr>

              <?php } ?>
              </tbody>
            </table>
          </div>
          </div>
         </div>
      </div>
   </div>
</div>

<!-- Manage Hours Modal -->
<div class="modal fade" id="hoursModal" tabindex="-1" role="dialog" aria-hidden="true">
  <div class="modal-dialog modal-lg" role="document">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title">Manage Hours: <span id="pitchName"></span></h5>
        <button type="button" class="close" data-dismiss="modal">&times;</button>
      </div>

      <div class="modal-body">
        <!-- Flash message -->
        <div id="hoursMsg"></div>

        <form id="hoursForm">
          <input type="hidden" name="pitch_id" id="pitchId">

          <div id="hoursFormContent"></div>

          <div class="form-group text-right">
            <button type="submit" class="btn btn-success">Save Hours</button>
          </div>
        </form>
      </div>
    </div>
  </div>
</div>


<script>
$(document).on("click", ".manage-hours", function(){
    var pitchId = $(this).data("id");
    var pitchName = $(this).data("name");

    $("#pitchId").val(pitchId);
    $("#pitchName").text(pitchName);

    // Load existing hours
    $.get("<?= base_url('Pitches/pitch_hours_get/'); ?>" + pitchId, function(html){
        $("#hoursFormContent").html(html);
    });

    $("#hoursModal").modal("show");
});

// Save hours
$("#hoursForm").submit(function(e){
    e.preventDefault();

    $.post("<?= base_url('Pitches/pitch_hours_save'); ?>", $(this).serialize(), function(response){
        let res = JSON.parse(response);
        if(res.status === 'success'){
            $("#hoursMsg").html('<p class="text-success">'+res.message+'</p>');
        } else {
            $("#hoursMsg").html('<p class="text-danger">'+res.message+'</p>');
        }
    });
});

function delete_function(id) {

$.confirm({
    title: 'Delete!',
    content: 'Are you want to delete this data?',
    type: 'red',
    typeAnimated: true,
    buttons: {
        tryAgain: {
            text: 'Yes',
            btnClass: 'btn-red',
            action: function(){
              $.ajax({
          type: "POST",
          url: "<?php echo base_url(); ?>Pitches/Delete/",
          data: {id : id }, 
          success: function(html) {
            $.alert("Your data has been successfully deleted");
            setInterval(function(){
              location.reload();
            }, 3000);
            }
          });
            }
        },
        close: function () {
        }
    }
 });
}

</script>

<style type="text/css">
  table.dataTable thead .sorting, 
table.dataTable thead .sorting_asc, 
table.dataTable thead .sorting_desc {
    background : none;
}
</style>