<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/jquery-confirm/3.3.0/jquery-confirm.min.css">
<script src="https://cdnjs.cloudflare.com/ajax/libs/jquery-confirm/3.3.0/jquery-confirm.min.js"></script>
<!-- TOP Nav Bar END -->
<div class="container-fluid">
   <div class="row">
      <div class="col-sm-12">
         <div class="iq-card">
            <div class="iq-card-header d-flex justify-content-between">
               <div class="iq-header-title">
                  <h4 class="card-title">OPD Doctor Appointment List</h4>
               </div>
               <span class="table-add float-right mb-3 mr-2">
                  <!-- <a href="<?php echo base_url(); ?>HealthCheckup/add" class="btn btn-sm iq-bg-success" ><i
                     class="ri-add-fill"><span class="pl-1">Add New</span></i>
                  </a> -->
                  </span>
            </div>
            <div class="iq-card-body">
             <div id="table" class="table-editable">
            <table id="myTable" class="display table" style="width:100%">
              <thead>
                <tr>
                    <th>Sl No.</th>
                    <th>Doctor Name</th>
                    <th>Department</th>
                    <th>Patient Name</th>
                    <th>Mobile</th>
                    <th>Email</th>
                    <th>Appointment Day</th>
                    <th>Problem</th>
                    <th>Status</th>
                </tr>
              </thead>
              <tbody>
                <?php  
                $start=0;
                for($i=0;$i<count($recordSet);$i++)
                   { $start++;
                    if($recordSet[$i]['status']=='Pending'){ 
                      $class='btn-primary';
                     }else if($recordSet[$i]['status']=='Scheduled'){ 
                      $class='btn-success';
                     } else{
                      $class='btn-danger';
                     }
                ?>
                <tr>
                    <td scope="row"><?php echo $start; ?></td>
                    <td><?php echo $recordSet[$i]['d_name'];?></td>
                    <td><?php echo $recordSet[$i]['department']; ?></td>
                    <td ><?php echo $recordSet[$i]['name']; ?></td>
                    <td ><?php echo $recordSet[$i]['mobile']; ?></td>
                    <td ><?php echo $recordSet[$i]['email']; ?></td>
                    <td ><?php echo $recordSet[$i]['appointment_date'].' - '.$recordSet[$i]['appointment_time']; ?></td>
                    <td ><?php echo $recordSet[$i]['problem']; ?></td>
                    <td ><button class="btn btn-sm <?php echo $class; ?> change-status-btn"
                              data-id="<?php echo $recordSet[$i]['oad_id']; ?>"
                              data-status="<?php echo $recordSet[$i]['status']; ?>">
                        <?php if($recordSet[$i]['status']==0){ echo 'Pending'; }else{ echo $recordSet[$i]['status']; } ; ?>
                      </button></td>
                    
                    <!-- <td>
                        <a href="<?php echo base_url().'HealthCheckup/Edit/'.$recordSet[$i]['hc_id']; ?>" class="edit" title="Edit"><i class="fa fa-pencil" aria-hidden="true"></i>   </a>
                        <a href="javascript:void(0)"  onclick="delete_function(<?php echo $recordSet[$i]['hc_id']; ?>);" class="delete remScnt" title="Delete"><i class="fa fa-trash" style="color:red;" aria-hidden="true" title="Delete"></i> </a> 
                    </td> -->
                </tr>

              <?php } ?>
              </tbody>
            </table>
          </div>
          </div>
         </div>
      </div>
   </div>
</div>
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
<!-- Change Status Modal -->
<div class="modal fade" id="changeStatusModal" tabindex="-1" aria-labelledby="changeStatusModalLabel" aria-hidden="true">
  <div class="modal-dialog">
    <form id="changeStatusForm">
      <div class="modal-content">
        <div class="modal-header">
          <h5 class="modal-title">Change Appointment Status</h5>
          <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
        </div>
        <div class="modal-body">
          <input type="hidden" id="oad_id" name="oad_id">
          <div class="mb-3">
            <label for="status" class="form-label">Select Status</label>
            <select class="form-control" id="status" name="status">
              <option value="Pending">Pending</option>
              <option value="Scheduled">Scheduled</option>
              <option value="Rejected">Rejected</option>
            </select>
          </div>
        </div>
        <div class="modal-footer">
          <button type="submit" class="btn btn-success">Update Status</button>
          <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
        </div>
      </div>
    </form>
  </div>
</div>

<script>
function delete_function(id) {

$.confirm({
    title: 'Delete!',
    content: 'Are you want to delete this data?',
    type: 'red',
    typeAnimated: true,
    buttons: {
        tryAgain: {
            text: 'Yes',
            btnClass: 'btn-red',
            action: function(){
              $.ajax({
          type: "POST",
          url: "<?php echo base_url(); ?>HealthCheckup/Delete/",
          data: {id : id }, 
          success: function(html) {
            $.alert("Your data has been successfully deleted");
            setInterval(function(){
              location.reload();
            }, 3000);
            }
          });
            }
        },
        close: function () {
        }
    }
 });
}
$(document).ready(function () {
    // Open modal with existing data
    $('.change-status-btn').on('click', function () {
        const oad_id = $(this).data('id');
        const currentStatus = $(this).data('status');

        $('#oad_id').val(oad_id);
        $('#status').val(currentStatus);
        $('#changeStatusModal').modal('show');
    });

    // Handle form submission via AJAX
    $('#changeStatusForm').on('submit', function (e) {
        e.preventDefault();

        $.ajax({
            url: '<?php echo base_url("OpdAppointmentBooking/update_status"); ?>',
            type: 'POST',
            data: $(this).serialize(),
            success: function (response) {
                $('#changeStatusModal').modal('hide');
                Swal.fire({
                    icon: 'success',
                    title: 'Status Updated',
                    text: 'Appointment status has been updated successfully.',
                    confirmButtonText: 'OK',
                    customClass: {
                        confirmButton: 'btn btn-success'
                    },
                    buttonsStyling: false
                }).then(() => {
                    location.reload(); // Reload page to see updated status
                });
            },
            error: function () {
                Swal.fire('Error', 'Failed to update status. Try again.', 'error');
            }
        });
    });
});

</script>

<style type="text/css">
  table.dataTable thead .sorting, 
table.dataTable thead .sorting_asc, 
table.dataTable thead .sorting_desc {
    background : none;
}
</style>