<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/jquery-confirm/3.3.0/jquery-confirm.min.css">
<script src="https://cdnjs.cloudflare.com/ajax/libs/jquery-confirm/3.3.0/jquery-confirm.min.js"></script>
<!-- TOP Nav Bar END -->
<style type="text/css">
  .label-status {
    padding: 5px 10px;
    font-size: 13px;
    font-weight: 600;
    color: #fff;
    border-radius: 4px;
    display: inline-block;
    text-transform: capitalize;
}

.label-red {
    background-color: #e74c3c; /* Red */
}

.label-green {
    background-color: #2ecc71; /* Green */
}
</style>
<div class="container-fluid">
   <div class="row">
      <div class="col-sm-12">
         <div class="iq-card">
            <div class="iq-card-header d-flex justify-content-between">
               <div class="iq-header-title">
                  <h4 class="card-title">Booking List</h4>
               </div>
               <span class="table-add float-right mb-3 mr-2">
                  <a href="<?php echo base_url(); ?>booking/add" class="btn btn-sm iq-bg-success" ><i
                     class="ri-add-fill"><span class="pl-1">Book New</span></i>
                  </a>
                  </span>
            </div>
            <div class="iq-card-body">
             <div id="table" class="table-editable">
            <table id="myTable" class="display table" style="width:100%">
              <thead>
                <tr>
                    <th>Sl No.</th>
                    <th>Booking No</th>
                    <th>Customer</th>
                    <th>Game</th>
                    <th>Pitch</th>
                    <th>Date & Time</th>
                    <th>Amount</th>
                    <th>Status</th>
                </tr>
              </thead>
              <tbody>
                <?php  
                $start=0;
                foreach($recent_bookings as $b)
                   { $start++;                
                ?>
                <tr>
                  <td><?= $start ?></td>
                  <td>#<?= $b->booking_no ?></td>
                  <td><?= $b->customer_name ?></td>
                  <td><?= $b->sport_name ?></td>
                  <td><?= $b->pitch_name ?></td>
                  <td><?= date('M d, Y', strtotime($b->booking_date)) ?><br>
                    <small><?= $b->start_time ?> - <?= $b->end_time ?></small></td>
                  <td>₹<?= $b->total_price ?></td>
                  <td>
                    <?php if($b->status=='confirmed'): ?>
                      <span class="badge bg-success">Confirmed</span>
                    <?php elseif($b->status=='pending'): ?>
                      <span class="badge bg-warning">Pending</span>
                    <?php else: ?>
                      <span class="badge bg-danger">Cancelled</span>
                    <?php endif; ?>
                  </td>
                </tr>

              <?php } ?>
              </tbody>
            </table>
          </div>
          </div>
         </div>
      </div>
   </div>
</div>
<script>



function delete_function(id) {

$.confirm({
    title: 'Delete!',
    content: 'Are you want to delete this data?',
    type: 'red',
    typeAnimated: true,
    buttons: {
        tryAgain: {
            text: 'Yes',
            btnClass: 'btn-red',
            action: function(){
              $.ajax({
          type: "POST",
          url: "<?php echo base_url(); ?>HealthCheckupBooking/Delete/",
          data: {id : id }, 
          success: function(html) {
            $.alert("Your data has been successfully deleted");
            setInterval(function(){
              location.reload();
            }, 3000);
            }
          });
            }
        },
        close: function () {
        }
    }
 });
}

</script>

<style type="text/css">
  table.dataTable thead .sorting, 
table.dataTable thead .sorting_asc, 
table.dataTable thead .sorting_desc {
    background : none;
}
</style>