<div class="container-fluid py-4">
  <!-- Top Stats -->
  <div class="row g-4 mb-4">
    <div class="col-md-3">
      <div class="card shadow-sm border-0 h-100">
        <div class="card-body d-flex align-items-center">
          <div class="me-3 bg-primary text-white p-3 rounded-circle">
            <i class="bi bi-people fs-4"></i>
          </div>
          <div>
            <h6 class="mb-1 text-muted">Total Customers</h6>
            <h4 class="mb-0 fw-bold"><?= $total_customers ?></h4>
          </div>
        </div>
      </div>
    </div>

    <div class="col-md-3">
      <div class="card shadow-sm border-0 h-100">
        <div class="card-body d-flex align-items-center">
          <div class="me-3 bg-success text-white p-3 rounded-circle">
            <i class="bi bi-calendar-check fs-4"></i>
          </div>
          <div>
            <h6 class="mb-1 text-muted">Total Bookings</h6>
            <h4 class="mb-0 fw-bold"><?= $total_bookings ?></h4>
          </div>
        </div>
      </div>
    </div>

    <div class="col-md-3">
      <div class="card shadow-sm border-0 h-100">
        <div class="card-body d-flex align-items-center">
          <div class="me-3 bg-warning text-white p-3 rounded-circle">
            <i class="bi bi-cash-stack fs-4"></i>
          </div>
          <div>
            <h6 class="mb-1 text-muted">Revenue</h6>
            <h4 class="mb-0 fw-bold">₹<?= number_format($total_revenue) ?></h4>
          </div>
        </div>
      </div>
    </div>

    <div class="col-md-3">
      <div class="card shadow-sm border-0 h-100">
        <div class="card-body d-flex align-items-center">
          <div class="me-3 bg-danger text-white p-3 rounded-circle">
            <i class="bi bi-trophy fs-4"></i>
          </div>
          <div>
            <h6 class="mb-1 text-muted">Active Sports</h6>
            <h4 class="mb-0 fw-bold"><?= $active_sports ?></h4>
          </div>
        </div>
      </div>
    </div>
  </div>

  <!-- Charts -->
  <div class="row g-4 mb-4">
    <div class="col-lg-8">
      <div class="card shadow-sm border-0 h-100">
        <div class="card-header bg-white border-0">
          <h5 class="card-title mb-0">Bookings Overview</h5>
        </div>
        <div class="card-body">
          <canvas id="bookingChart" height="120"></canvas>
        </div>
      </div>
    </div>

    <div class="col-lg-4">
      <div class="card shadow-sm border-0 h-100">
        <div class="card-header bg-white border-0">
          <h5 class="card-title mb-0">Sports Popularity</h5>
        </div>
        <div class="card-body">
          <canvas id="sportsPie" height="250"></canvas>
        </div>
      </div>
    </div>
  </div>

  <!-- Recent Bookings -->
  <div class="card shadow-sm border-0">
    <div class="card-header bg-white border-0 d-flex justify-content-between align-items-center">
      <h5 class="card-title mb-0">Recent Bookings</h5>
    </div>
    <div class="table-responsive">
      <table class="table align-middle mb-0">
        <thead class="table-light">
          <tr>
            <th>Booking No</th>
            <th>Customer</th>
            <th>Game</th>
            <th>Pitch</th>
            <th>Date & Time</th>
            <th>Amount</th>
            <th>Status</th>
          </tr>
        </thead>
        <tbody>
          <?php foreach($recent_bookings as $b): ?>
          <tr>
            <td>#<?= $b->booking_no ?></td>
            <td><?= $b->customer_name ?></td>
            <td><?= $b->sport_name ?></td>
            <td><?= $b->pitch_name ?></td>
            <td><?= date('M d, Y', strtotime($b->booking_date)) ?><br>
              <small><?= $b->start_time ?> - <?= $b->end_time ?></small></td>
            <td>₹<?= $b->total_price ?></td>
            <td>
              <?php if($b->status=='confirmed'): ?>
                <span class="badge bg-success">Confirmed</span>
              <?php elseif($b->status=='pending'): ?>
                <span class="badge bg-warning">Pending</span>
              <?php else: ?>
                <span class="badge bg-danger">Cancelled</span>
              <?php endif; ?>
            </td>
          </tr>
          <?php endforeach; ?>
        </tbody>
      </table>
    </div>
  </div>
</div>

<!-- Chart.js -->
<script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
<script>
  // Monthly bookings
  const monthlyData = <?= json_encode(array_column($monthly_bookings,'total')) ?>;
  const monthLabels = <?= json_encode(array_column($monthly_bookings,'month')) ?>;

  new Chart(document.getElementById('bookingChart'), {
    type: 'line',
    data: {
      labels: monthLabels,
      datasets: [{
        label: 'Bookings',
        data: monthlyData,
        borderColor: '#0d6efd',
        backgroundColor: 'rgba(13,110,253,0.1)',
        fill: true,
        tension: 0.4
      }]
    }
  });

  // Sports popularity
  const sportLabels = <?= json_encode(array_column($sports_popularity,'name')) ?>;
  const sportValues = <?= json_encode(array_column($sports_popularity,'total')) ?>;

  new Chart(document.getElementById('sportsPie'), {
    type: 'doughnut',
    data: {
      labels: sportLabels,
      datasets: [{
        data: sportValues,
        backgroundColor: ['#198754','#0d6efd','#ffc107','#dc3545','#6f42c1','#20c997','#fd7e14']
      }]
    }
  });
</script>
