<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Vehicle extends CI_Controller {

	function __construct() 
	{
        error_reporting(0);
        parent::__construct();
        $this->load->model('CommonModel');
        $this->load->helper('Security');
        $this->load->library('form_validation');

       
    }

	public function index()
	{ 
		if(isAdmin())
		{ 
			$data['recordSet']=$this->db->select('v.vehicle_id,v.vt_id,mv.m_id,ml.mobile_number,v.project_id,v.equipment_id,v.equipment_name,v.equipment_model,v.capacity,v.vehicle_status,v.breakdown_status,vt.vehicle_type, p.project_code')->from('vehicle as v')->join('project as p', 'v.project_id = p.project_id', 'LEFT')->join('vehicle_type as vt', 'v.vt_id = vt.vt_id', 'LEFT')->join('mobile_vehicle as mv', 'v.vehicle_id = mv.vehicle_id', 'LEFT')->join('mobile_list as ml', 'ml.m_id = mv.m_id', 'LEFT')->order_by('vehicle_id','desc')->get()->result_array();
			$data['content'] = 'Vehicle/Listing';
			$this->load->view('layout_home', $data);
		}
	}

	public function add()
	{
		if(isAdmin())
		{
			$data['recordSet']=$this->db->get('vehicle_type')->result_array();
			$data['project']=$this->db->where('status', '1')->get('project')->result_array();
			$data['content'] = 'Vehicle/Add';
			$this->load->view('layout_home', $data);
		}
	}
	public function edit($para1)
	{
		if(isAdmin())
		{
			$data['recordSet']=$this->db->get('vehicle_type')->result_array();
			$data['project']=$this->db->where('status', '1')->get('project')->result_array();
			$data['row']= $this->CommonModel->fetch_a_row('vehicle_id',$para1,'vehicle');
            $data['content']  ="Vehicle/Edit";
            $this->load->view('layout_home',$data);
		}
	}

	public function save()
	{
		if(isAdmin())
		{
			$input_data = $this->input->post();
            $input_data = $this->security->xss_clean($input_data);

            $duplicate_data=$this->db->where('equipment_name', $input_data['equipment_name'])->get('vehicle')->result_array();
            if(empty($duplicate_data))
            {
            
        	$insert_data['vt_id'] = $input_data['vt_id'];
        	$insert_data['project_id'] = $input_data['project_id'];
        	$insert_data['equipment_id'] = '0';
        	$insert_data['equipment_name'] = $input_data['equipment_name'];
        	$insert_data['equipment_model'] = $input_data['equipment_model'];
        	$insert_data['capacity'] = $input_data['capacity'];
        	$insert_data['vehicle_status'] = 1;
        	
            $this->db->insert('vehicle',$insert_data);
            echo 'Success';
        	}
		}
	}

	public function Edit_data()
	{
	    if(isAdmin())
	    {  
	        	$input_data = $this->input->post();
	            $input_data = $this->security->xss_clean($input_data);
	            $duplicate_data=$this->db->where('equipment_name', $input_data['equipment_name'])->where('vehicle_id !=', $input_data['vehicle_id'])->get('vehicle')->result_array();
	            if(empty($duplicate_data))
	            {
	            $edit_data['vt_id'] = $input_data['vt_id'];
	        	$edit_data['project_id'] = $input_data['project_id'];
	        	$edit_data['equipment_name'] = $input_data['equipment_name'];
	        	$edit_data['equipment_model'] = $input_data['equipment_model'];
	        	$edit_data['capacity'] = $input_data['capacity'];
	        	
	            $this->db->where('vehicle_id',$input_data['vehicle_id']);
	            $this->db->update('vehicle',$edit_data);
	            echo 'success';
	        	}
	    }      
	}
	public function status_change()
	{
	    if(isAdmin())
	    {  
	        	$input_data = $this->input->post();
	            $input_data = $this->security->xss_clean($input_data);
	            $edit_data['vehicle_status'] = $input_data['new_status'];
	        	
	            $this->db->where('vehicle_id',$input_data['id']);
	            $this->db->update('vehicle',$edit_data);
	            echo 'success';
	    }      
	}
	public function Delete()
    {
        if(isAdmin())
        {
        	$input_data = $this->input->post();
        	$this->db->where('vehicle_id', $input_data['id']);
			$this->db->delete('vehicle');
             // / ---------------------------Insert Audit trail--------------------
            $audit_trail_table='audit_trail';
	        $audit_trail_array=array(
	                                    'user_name'=>$this->session->userdata('admin_name'),
	                                    'action'=>'Action -> "Delete Vehicle"',
	                                    'action_time'=>date('Y-m-d H:i:s')
	                                );
        	$this->CommonModel->insert($audit_trail_table,$audit_trail_array);
        }
    }
    public function export()
	{
		if(isAdmin())
		{ 
			$fetch_array=$this->db->select('v.vehicle_id,v.vt_id,v.project_id,v.equipment_id,v.equipment_name,v.equipment_model,v.capacity,v.vehicle_status,vt.vehicle_type, p.project_code')->from('vehicle as v')->join('project as p', 'v.project_id = p.project_id', 'LEFT')->join('vehicle_type as vt', 'v.vt_id = vt.vt_id', 'LEFT')->order_by('vehicle_id','desc')->get()->result_array();
			header("Content-type: application/csv");
		    header("Content-Disposition: attachment; filename=\"vehicle-".date('d-m-Y').".csv\"");
		    header("Pragma: no-cache");
		    header("Expires: 0");

		     $handle = fopen('php://output', 'w');
			$excel_heding=array();
			array_push($excel_heding, 'SL',   'Project', 'Equipment Name','Equipment Model','Vehicle Type','Capacity','Status','Date');
			fputcsv($handle, $excel_heding);
			foreach ($fetch_array as $key => $row_data) {
			$export_req = array();
			if ($row_data['status']=='1') {
			$status='Active';
			}
			else
			{
			$status='Inactive';
			}
			array_push($export_req, $key+1,   $row_data['project_code'],  $row_data['equipment_name'],  $row_data['equipment_model'],  $row_data['vehicle_type'],  $row_data['capacity'],  $status, $row_data['date']);

			//print_r($call_det);die;
			fputcsv($handle, $export_req);
			} 
			 fclose($handle);
		     exit;
		
		}
	}



	


	public function import(){

        $data = array();

        $memData = array();

                $insertCount = $updateCount = $rowCount = $notAddCount = 0;

                if(is_uploaded_file($_FILES['import_data']['tmp_name'])){

                    $this->load->library('CSVReader');

                    $csvData = $this->csvreader->parse_csv($_FILES['import_data']['tmp_name']);

                    if(!empty($csvData)){

                        foreach($csvData as $row){ 
                        	
                        	$rowCount++;
                        	$vehicle_type_det=$this->db->where('vehicle_type', $row['Vehicle Type'])->get('vehicle_type')->result_array();
                        	$project_det=$this->db->where('project_code', $row['Project Code'])->get('project')->result_array();
                        	$duplicate_data=$this->db->where('equipment_name', $row['Equipment Name'])->get('vehicle')->result_array();
                        	
				            if(empty($duplicate_data))
				            {
							$insert_data['vt_id'] = $vehicle_type_det['0']['vt_id'];
							$insert_data['project_id'] = $project_det['0']['project_id'];
							$insert_data['equipment_id'] = '0';
							$insert_data['equipment_name'] = $row['Equipment Name'];
							$insert_data['equipment_model'] = $row['Equipment Model'];
							$insert_data['capacity'] = $row['Capacity'];
							$insert_data['vehicle_status'] = 1;
							
							$this->db->insert('vehicle',$insert_data);
							}
							else
							{
				        	// $edit_data['project_id'] = $project_det['0']['project_id'];
				        	
				            // $this->db->where('vehicle_id',$duplicate_data['0']['vehicle_id']);
				            // $this->db->update('vehicle',$edit_data);
				            //echo $this->db->last_query();die;
							}



                          $insertCount++;  

                        }
                        $notAddCount = ($rowCount - ($insertCount + $updateCount));
                    }
                }

    }

}