<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Users extends CI_Controller {

	function __construct() 
	{
        error_reporting(0);
        parent::__construct();
        $this->load->model('CommonModel');
        $this->load->helper('Security');
        $this->load->library('form_validation');

       
    }

	public function index()
	{ 
		if(isAdmin())
		{ 
			$data['recordSet']=$this->db->get('admin')->result_array();
			$data['content'] = 'Users/Listing';
			$this->load->view('layout_home', $data);
		}
	}

	public function add()
	{
		if(isAdmin())
		{
			$data['content'] = 'Users/Add';
			$this->load->view('layout_home', $data);
		}
	}
	public function edit($para1)
	{
		if(isAdmin())
		{
			$data['row']= $this->CommonModel->fetch_a_row('admin_id',$para1,'admin');
            $data['content']  ="Users/Edit";
            $this->load->view('layout_home',$data);
		}
	}

	public function save()
	{
		if(isAdmin())
		{
			$input_data = $this->input->post();
            $input_data = $this->security->xss_clean($input_data);

            $md5_convert_data = md5($input_data['e_password']);
			$salt_key = get_encript_id($input_data['e_password']);
			$password = $md5_convert_data . $salt_key;
            
        	$insert_data['fullname'] = $input_data['e_name'];
        	$insert_data['email'] = $input_data['e_email'];
        	$insert_data['mobile_no'] = $input_data['e_mobile'];
        	$insert_data['role_id'] = $input_data['e_employee_type'];
        	$insert_data['password'] = $password;
        	$insert_data['hotel'] = 'HN';
        	$insert_data['status'] = 1;
        	
            $this->db->insert('admin',$insert_data);
            echo 'Success';
		}
	}

	public function Edit_data()
	{
	    if(isAdmin())
	    {  
	        	$input_data = $this->input->post();
	            $input_data = $this->security->xss_clean($input_data);
	            $edit_data['Users_code'] = $input_data['Users_code'];
	        	$edit_data['e_name'] = $input_data['e_name'];
	        	$edit_data['e_email'] = $input_data['e_email'];
	        	$edit_data['e_mobile'] = $input_data['e_mobile'];
	        	$edit_data['e_Users_type'] = $input_data['e_Users_type'];
	        	$edit_data['e_address'] = $input_data['e_address'];
	        	$edit_data['join_date'] = $input_data['join_date'];
	        	$edit_data['e_password'] = base64_encode($input_data['e_password']);
	        	
	            $this->db->where('e_id',$input_data['e_id']);
	            $this->db->update('Users',$edit_data);
	            echo 'Success';
	    }      
	}
	public function status_change()
	{
	    if(isAdmin())
	    {  
	        	$input_data = $this->input->post();
	            $input_data = $this->security->xss_clean($input_data);
	            $edit_data['login_status'] = $input_data['new_status'];
	        	
	            $this->db->where('admin_id',$input_data['id']);
	            $this->db->update('admin',$edit_data);
	            echo 'success';
	    }      
	}
	public function Delete()
    {
        if(isAdmin())
        {
        	$input_data = $this->input->post();
        	$this->db->where('admin_id', $input_data['id']);
			$this->db->delete('admin');
             // / ---------------------------Insert Audit trail--------------------
            $audit_trail_table='audit_trail';
	        $audit_trail_array=array(
	                                    'user_name'=>$this->session->userdata('admin_name'),
	                                    'action'=>'Action -> "Delete Users"',
	                                    'action_time'=>date('Y-m-d H:i:s')
	                                );
        	$this->CommonModel->insert($audit_trail_table,$audit_trail_array);
        }
    }

    public function export()
	{
		if(isAdmin())
		{ 
			$project_array=$this->db->get('Users')->result_array();
			header("Content-type: application/csv");
		    header("Content-Disposition: attachment; filename=\"empolyee-".date('d-m-Y').".csv\"");
		    header("Pragma: no-cache");
		    header("Expires: 0");

		     $handle = fopen('php://output', 'w');
			$excel_heding=array();
			array_push($excel_heding, 'SL', 'Users Code', 'Name', 'Email ID', 'Mobile', 'Address',  'Status','Join Date');
			fputcsv($handle, $excel_heding);
			foreach ($project_array as $key => $project_data) {
			$export_req = array();
			if ($project_data['e_status']=='1') {
			$status='Active';
			}
			else
			{
			$status='Inactive';
			}
			array_push($export_req, $key+1, $project_data['Users_code'], $project_data['e_name'], $project_data['e_email'], $project_data['e_mobile'], $project_data['e_address'], $status, $project_data['join_date']);

			//print_r($call_det);die;
			fputcsv($handle, $export_req);
			} 
			 fclose($handle);
		     exit;
		
		}
	}
	public function import(){

        $data = array();

        $memData = array();

                $insertCount = $updateCount = $rowCount = $notAddCount = 0;

                if(is_uploaded_file($_FILES['import_data']['tmp_name'])){

                    $this->load->library('CSVReader');

                    $csvData = $this->csvreader->parse_csv($_FILES['import_data']['tmp_name']);

                    if(!empty($csvData)){

                        foreach($csvData as $row){ 
                        	$rowCount++;
                        	
							$insert_data['Users_code'] = $row['Users Code'];
							$insert_data['e_name'] = $row['Name'];
							$insert_data['e_email'] = $row['Email ID'];
							$insert_data['e_mobile'] = $row['Mobile Number'];
							$insert_data['e_address'] = $row['Address'];
							$insert_data['e_password'] = $row['Password'];
							$insert_data['e_status'] = '1';
							$insert_data['join_date'] = date('Y-m-d H:i:s');
							
							$this->db->insert('Users',$insert_data);						
							
                          $insertCount++;  

                        }
                        $notAddCount = ($rowCount - ($insertCount + $updateCount));
                    }
                }

    }

}