<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Room extends CI_Controller {

	function __construct() 
	{
        error_reporting(0);
        parent::__construct();
        $this->load->model('CommonModel');
        $this->load->helper('Security');
        $this->load->library('form_validation');

       
    }

	public function index()
	{ 
		if(isAdmin())
		{ 
			$data['recordSet']=$this->db->get('rooms')->result_array();
			$data['content'] = 'Room/Listing';
			$this->load->view('layout_home', $data);
		}
	}

	public function add()
	{
		if(isAdmin())
		{
			$data['ameData']=$this->db->get('aminities')->result_array();
			$data['content'] = 'Room/Add';
			$this->load->view('layout_home', $data);
		}
	}
	public function edit($para1)
	{
		if(isAdmin())
		{
			$data['row']= $this->CommonModel->fetch_a_row('r_id',$para1,'rooms');
			$data['ameData']=$this->db->get('aminities')->result_array();
            $data['content']  ="Room/Edit";
            $this->load->view('layout_home',$data);
		}
	}

	public function save()
	{
		if(isAdmin())
		{
			$input_data = $this->input->post();
            $input_data = $this->security->xss_clean($input_data);

            
    	    $amenities=implode(",", $_POST['amenities']);
        	$insert_data['amenities'] = $amenities;
        	$insert_data['room_numbers'] = '';
        	$insert_data['r_type'] = $input_data['r_type'];
        	$insert_data['r_price'] = $input_data['r_price'];
        	$insert_data['total_room'] = $input_data['total_room'];
        	$insert_data['available_room'] = $input_data['total_room'];
        	$insert_data['maximum_allow'] = $input_data['maximum_allow'];
        	$insert_data['r_status'] = 1;
            $this->db->insert('rooms',$insert_data);
            $last_id=$this->db->insert_id();
        	/////////////////Room Data//////////////////
        	foreach ($input_data['room_numbers'] as $key => $room_numbers) 
            {
            	$insert_inv_data['r_id'] = $last_id;
        		$insert_inv_data['room_number'] = $room_numbers;
        		$insert_inv_data['room_status'] = 'Available';
        		$insert_inv_data['status'] = 1;
        		$this->db->insert('room_numbers',$insert_inv_data);
            }
            echo 'Success';
		}
	}

	public function Edit_data()
	{
	    if(isAdmin())
	    {  
	        	$input_data = $this->input->post();
	            $input_data = $this->security->xss_clean($input_data);
	            $amenities=implode(",", $_POST['amenities']);
	        	$insert_data['amenities'] = $amenities;
	        	$insert_data['room_numbers'] = '';
	        	$insert_data['r_type'] = $input_data['r_type'];
	        	$insert_data['r_price'] = $input_data['r_price'];
	        	$insert_data['total_room'] = $input_data['total_room'];
        		$insert_data['available_room'] = $input_data['total_room'];
	        	$insert_data['maximum_allow'] = $input_data['maximum_allow'];

	        	
	            $this->db->where('r_id',$input_data['r_id']);
	            $this->db->update('rooms',$insert_data);

	            /////////////////Room Data//////////////////
	        	foreach ($input_data['room_numbers'] as $key => $room_numbers) 
	            {
	            	if($input_data['rn_id'][$key]){
		        		$insert_inv_data['room_number'] = $room_numbers;
		        		$this->db->where('r_id',$input_data['r_id']);
		        		$this->db->where('rn_id',$input_data['rn_id'][$key]);
		        		$this->db->update('room_numbers',$insert_inv_data);
	        		} else{
	        			$insert_inv_data['r_id'] = $input_data['r_id'];
		        		$insert_inv_data['room_number'] = $room_numbers;
		        		$insert_inv_data['room_status'] = 'Available';
		        		$insert_inv_data['status'] = 1;
		        		$this->db->insert('room_numbers',$insert_inv_data);
	        		}
	            }
	            echo 'Success';
	    }      
	}
	public function status_change()
	{
	    if(isAdmin())
	    {  
	        	$input_data = $this->input->post();
	            $input_data = $this->security->xss_clean($input_data);
	            $edit_data['r_status'] = $input_data['new_status'];
	        	
	            $this->db->where('r_id',$input_data['id']);
	            $this->db->update('rooms',$edit_data);
	            echo 'success';
	    }      
	}
	public function Delete()
    {
        if(isAdmin())
        {
        	$input_data = $this->input->post();
        	$this->db->where('r_id', $input_data['id']);
			$this->db->delete('rooms');
             // / ---------------------------Insert Audit trail--------------------
            $audit_trail_table='audit_trail';
	        $audit_trail_array=array(
	                                    'user_name'=>$this->session->userdata('admin_name'),
	                                    'action'=>'Action -> "Delete Rooms"',
	                                    'action_time'=>date('Y-m-d H:i:s')
	                                );
        	$this->CommonModel->insert($audit_trail_table,$audit_trail_array);
        }
    }
	public function delete_room_number()
    {
        if(isAdmin())
        {
        	$input_data = $this->input->post();
        	$this->db->where('rn_id', $input_data['rn_id']);
			$this->db->delete('room_numbers');
        }
    }

    public function export()
	{
		if(isAdmin())
		{ 
			$project_array=$this->db->get('room_category')->result_array();
			header("Content-type: application/csv");
		    header("Content-Disposition: attachment; filename=\"rooms-".date('d-m-Y').".csv\"");
		    header("Pragma: no-cache");
		    header("Expires: 0");

		     $handle = fopen('php://output', 'w');
			$excel_heding=array();
			array_push($excel_heding, 'SL', 'Rooms Name',  'Status');
			fputcsv($handle, $excel_heding);
			foreach ($project_array as $key => $project_data) {
			$export_req = array();
			if ($project_data['cat_status']=='1') {
			$status='Active';
			}
			else
			{
			$status='Inactive';
			}
			array_push($export_req, $key+1, $project_data['rc_name'], $status);

			//print_r($call_det);die;
			fputcsv($handle, $export_req);
			} 
			 fclose($handle);
		     exit;
		
		}
	}
	public function import(){

        $data = array();

        $memData = array();

                $insertCount = $updateCount = $rowCount = $notAddCount = 0;

                if(is_uploaded_file($_FILES['import_data']['tmp_name'])){

                    $this->load->library('CSVReader');

                    $csvData = $this->csvreader->parse_csv($_FILES['import_data']['tmp_name']);

                    if(!empty($csvData)){

                        foreach($csvData as $row){ 
                        	$rowCount++;
                        	
							$insert_data['Rooms_code'] = $row['Rooms Code'];
							$insert_data['e_name'] = $row['Name'];
							$insert_data['e_email'] = $row['Email ID'];
							$insert_data['e_mobile'] = $row['Mobile Number'];
							$insert_data['e_address'] = $row['Address'];
							$insert_data['e_password'] = $row['Password'];
							$insert_data['e_status'] = '1';
							$insert_data['join_date'] = date('Y-m-d H:i:s');
							
							$this->db->insert('Rooms',$insert_data);						
							
                          $insertCount++;  

                        }
                        $notAddCount = ($rowCount - ($insertCount + $updateCount));
                    }
                }

    }

}