<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Reservation extends CI_Controller {

	function __construct() 
	{
        error_reporting(0);
        parent::__construct();
        $this->load->model('CommonModel');
        $this->load->helper('Security');
        $this->load->library('form_validation');

       
    }

	public function index()
	{ 
		if(isAdmin())
		{ 
			$data['recordSet']=$this->db->order_by("wr_id", "desc")->get('walk_in_reservation')->result_array();
			$data['content'] = 'Reservation/Listing';
			$this->load->view('layout_home', $data);
		}
	}

	public function add()
	{
		if(isAdmin())
		{
			$data['recordSet']=$this->db->get('rooms')->result_array();
			$data['content'] = 'Reservation/Add';
			$this->load->view('layout_home', $data);
		}
	}
	public function print($para1)
	{
		if(isAdmin())
		{
			//$data['recordSet']= $this->CommonModel->fetch_a_row('wr_id',$para1,'reservation_billing');
			$data['recordSet']= $this->db->where('wr_id',$para1)->order_by('billing_id','desc')->get('reservation_billing')->result_array();
            $data['content']  ="Reservation/bill_print";
            $this->load->view('layout_home',$data);
		}
	}
	public function receipt_print($para1)
	{
		if(isAdmin())
		{
			//$data['recordSet']= $this->CommonModel->fetch_a_row('wr_id',$para1,'reservation_billing');
			$data['recordSet']= $this->db->where('wr_id',$para1)->get('walk_in_reservation')->result_array();
            $data['content']  ="Reservation/receipt_print";
            $this->load->view('layout_home',$data);
		}
	}
	public function getroomno()
	{
		if(isAdmin())
		{
			$input_data = $this->input->post();
			$data = $this->db->where('r_id', $input_data['type1'])->where('room_status', 'Available')->get('room_numbers')->result_array();
			$data1 = $this->db->where('r_id', $input_data['type1'])->get('rooms')->result_array();
			?>
			<div class="form-group">
                <label for="InputText1">Room Number </label>
                <select class="form-control" name="room_numbers" id="room_numbers" required onchange="getAmount()">
                  <option value="">--Select Room Number--</option>
                  <?php foreach ($data as $key_room) { ?>
                    <option value="<?php echo $key_room['room_number']; ?>"><?php echo $key_room['room_number']; ?></option>
                  <?php } ?>
                </select>
                <input type="hidden" name="rn_id" value="<?php echo $key_room['rn_id']; ?>">
             </div>
			<?php
		}
	}
	public function get_amount()
	{
		if(isAdmin())
		{
			$input_data = $this->input->post();
			$data = $this->db->where('r_id', $input_data['room'])->get('rooms')->result_array();


//print_r($rooms_details);
 $num_emp=$input_data['num_emp'];
$extra_bed_price=0;
if($num_emp>2)
{
$extra_guest=$num_emp-2;

	 $extra_guest=$extra_guest/2;

 $total_extra_bed=ceil($extra_guest);
}
 $extra_bed_price=$total_extra_bed*$data[0]['extra_bed'];

			$total_amount=$data[0]['r_price']+$extra_bed_price;
			$total=$total_amount*$input_data['selectedValue'];
			echo $total;
		}
	}
	public function get_coupon_amount()
	{
		if(isAdmin())
		{
			$input_data = $this->input->post();
			$data = $this->db->where('cp_code', $input_data['selectedValue'])->where('status','1')->where('cp_quantity >', 0)->get('coupon')->result_array();
			if($data){
			$total_amount=$input_data['total_amount'];
			if($data[0]['discount_type']=='Rupees'){
				$total=$total_amount-$data[0]['discount'];
			} else{
				$discountDecimal = $data[0]['discount'] / 100;
			    $total = $total_amount - ($total_amount * $discountDecimal);	
			}
			echo $total;
			} else{
				echo 'failed';
			}
		}
	}
	public function save()
	{
		if(isAdmin())
		{
			$input_data = $this->input->post();
            $input_data = $this->security->xss_clean($input_data);

            
			/////// Guest Picture Upload ///////////////////////
    		$_FILES['userfile']['name']     = $_FILES['guest_picture']['name'][0];
	        $_FILES['userfile']['type']     = $_FILES['guest_picture']['type'][0];
	        $_FILES['userfile']['tmp_name'] = $_FILES['guest_picture']['tmp_name'][0];
	        $_FILES['userfile']['error']    = $_FILES['guest_picture']['error'][0];
	        $_FILES['userfile']['size']     = $_FILES['guest_picture']['size'][0];
			$config = array('upload_path' => "./uploads/guest_picture/",
							'allowed_types' => "gif|jpg|png|jpeg",
							'overwrite' => TRUE,
							'encrypt_name' => TRUE
							);
			$this->load->library('upload', $config);
			$this->upload->initialize($config);
			if($this->upload->do_upload())
			{
				$data = array('upload_data' => $this->upload->data());
				$file_name=$data['upload_data']['file_name'];
				$insert_data['guest_picture'] = $file_name;
				$config["source_image"] = './uploads/guest_picture/'.$file_name;
				$config['new_image'] = './uploads/guest_picture/thumbnail/';
				$config['image_library']  = 'gd2';
				$config['create_thumb'] =  FALSE;
				$config['overwrite'] = TRUE;
				$config['maintain_ratio'] = FALSE;
				$config["width"] = 500;
				$config["height"] = 500;
				$this->load->library('image_lib', $config);
				$this->image_lib->initialize($config);
				$this->image_lib->resize();
				$this->image_lib->clear();
			}

$rooms_details=$this->db->where('r_id',$input_data['r_id'])->get('rooms')->result_array();
//print_r($rooms_details);
// $guest_total=sizeof($input_data['guest_name']);
// $extra_bed_price=0;
// if($guest_total>2)
// {
// $extra_guest=$guest_total-2;

// 	 $extra_guest=$extra_guest/2;

//  $total_extra_bed=ceil($extra_guest);
// }

//  $extra_bed_price=$total_extra_bed*$rooms_details[0]['extra_bed'];
$total_amount=$input_data['total_amount'];
$before_disc_amount=$input_data['amount'];

			// if($input_data['extra_bed_price']==''){
			// 	$extra_bed_price=0;
			// }else{
			// 	$extra_bed_price=$input_data['extra_bed_price'];
			// }
			
            $edit_room['room_status'] = 'Check In';
        	
            $this->db->where('room_number',$input_data['room_numbers']);
            $this->db->update('room_numbers',$edit_room);

			$guest_total=0;
			$indate=explode(' ', $input_data['check_in']);
			$outdate=explode(' ', $input_data['check_out']);
        	$insert_data['r_id'] = $input_data['r_id'];
        	$insert_data['e_id'] = $this->session->userdata('admin_id');
        	$insert_data['booking_code'] = 'HM'.rand(1,100).date('YmdHis');
        	$insert_data['room_number'] = $input_data['room_numbers'];
        	$insert_data['num_rooms'] = $input_data['num_rooms'];
        	$insert_data['num_guest'] = $guest_total;
        	$insert_data['extra_bed'] = $input_data['extra_bed'];
        	//$insert_data['extra_bed_price'] = $extra_bed_price;
        	$insert_data['extra_bed_price'] = $input_data['extra_bed_price'];
        	$insert_data['guest_type'] = $input_data['guest_type'];
        	$insert_data['wr_visit_purpose'] = $input_data['wr_visit_purpose'];
        	$insert_data['coming_from'] = $input_data['coming_from'];
        	$insert_data['going_to'] = $input_data['going_to'];
        	$insert_data['booking_source'] = $input_data['booking_source'];
        	$insert_data['payment_mode'] = $input_data['payment_mode'];
        	$insert_data['total_amount'] = $total_amount;
        	$insert_data['amount'] = $before_disc_amount;
        	$insert_data['discount'] = $before_disc_amount-$total_amount;
        	$insert_data['adv_amount'] = $input_data['adv_amount'];
        	$insert_data['coupon_code'] = $input_data['coupon_code'];
        	$insert_data['check_in'] = date("Y-m-d", strtotime($indate[0]));
        	$insert_data['check_out'] = date("Y-m-d", strtotime($outdate[0]));
        	$insert_data['check_in_time'] = $indate[1];
        	$insert_data['check_out_time'] = $outdate[1];
        	$insert_data['status'] = '1';
        	$insert_data['hotel'] = $this->session->userdata('hotel_name');
        	
            $this->db->insert('walk_in_reservation',$insert_data);
            $last_id=$this->db->insert_id();
            //echo $this->db->last_query();
            $guest=0;
            foreach ($input_data['guest_name'] as $key => $guest_name) 
            {
        	/////// Document Upload ///////////////////////
    		$_FILES['userfile']['name']     = $_FILES['documents']['name'][$key];
	        $_FILES['userfile']['type']     = $_FILES['documents']['type'][$key];
	        $_FILES['userfile']['tmp_name'] = $_FILES['documents']['tmp_name'][$key];
	        $_FILES['userfile']['error']    = $_FILES['documents']['error'][$key];
	        $_FILES['userfile']['size']     = $_FILES['documents']['size'][$key];
			$config = array('upload_path' => "./uploads/documents/",
							'allowed_types' => "gif|jpg|png|jpeg",
							'overwrite' => TRUE,
							'encrypt_name' => TRUE
							);
			$this->load->library('upload', $config);
			$this->upload->initialize($config);
			if($this->upload->do_upload())
			{
				$data = array('upload_data' => $this->upload->data());
				$file_name=$data['upload_data']['file_name'];
				$insert_inv_data['documents'] = $file_name;
				$config["source_image"] = './uploads/documents/'.$file_name;
				$config['new_image'] = './uploads/documents/thumbnail/';
				$config['image_library']  = 'gd2';
				$config['create_thumb'] =  FALSE;
				$config['overwrite'] = TRUE;
				$config['maintain_ratio'] = FALSE;
				$config["width"] = 500;
				$config["height"] = 500;
				$this->load->library('image_lib', $config);
				$this->image_lib->initialize($config);
				$this->image_lib->resize();
				$this->image_lib->clear();
			}
        	/////// Guest Picture Upload ///////////////////////
    		$_FILES['userfile']['name']     = $_FILES['guest_picture']['name'][$key];
	        $_FILES['userfile']['type']     = $_FILES['guest_picture']['type'][$key];
	        $_FILES['userfile']['tmp_name'] = $_FILES['guest_picture']['tmp_name'][$key];
	        $_FILES['userfile']['error']    = $_FILES['guest_picture']['error'][$key];
	        $_FILES['userfile']['size']     = $_FILES['guest_picture']['size'][$key];
			$config = array('upload_path' => "./uploads/guest_picture/",
							'allowed_types' => "gif|jpg|png|jpeg",
							'overwrite' => TRUE,
							'encrypt_name' => TRUE
							);
			$this->load->library('upload', $config);
			$this->upload->initialize($config);
			if($this->upload->do_upload())
			{
				$data = array('upload_data' => $this->upload->data());
				$guestPicture=$data['upload_data']['file_name'];
				$insert_inv_data['guest_picture'] = $guestPicture;
				$config["source_image"] = './uploads/guest_picture/'.$guestPicture;
				$config['new_image'] = './uploads/guest_picture/thumbnail/';
				$config['image_library']  = 'gd2';
				$config['create_thumb'] =  FALSE;
				$config['overwrite'] = TRUE;
				$config['maintain_ratio'] = FALSE;
				$config["width"] = 500;
				$config["height"] = 500;
				$this->load->library('image_lib', $config);
				$this->image_lib->initialize($config);
				$this->image_lib->resize();
				$this->image_lib->clear();
			}
            $guest++;
        	$insert_inv_data['wr_id'] = $last_id;
        	$insert_inv_data['guest_name'] = $guest_name;
        	$insert_inv_data['guest_phone'] = $input_data['guest_phone'][$key];
        	$insert_inv_data['guest_age'] = $input_data['guest_age'][$key];
        	$insert_inv_data['guest_address'] = $input_data['guest_address'][$key];
        	$insert_inv_data['documents_type'] = $input_data['documents_type'][$key];
        	$insert_inv_data['document_number'] = $input_data['document_number'][$key];
        	$insert_inv_data['check_in_time'] = date('d-m-y H:i:s');
            $this->db->insert('walk_in_guest',$insert_inv_data);
            }

            $edit_data['num_guest'] = $guest;	
            $this->db->where('wr_id',$last_id);
            $this->db->update('walk_in_reservation',$edit_data);



            $gd_insert_data['wr_id'] = $last_id;
            $gd_insert_data['gd_check_in'] = $input_data['num_adult'];
            $gd_insert_data['gd_check_out'] = 0;
            $gd_insert_data['gd_amount'] = $total_amount;
        	$gd_insert_data['gd_room_type'] = $input_data['r_id'];
        	$gd_insert_data['gd_date'] = date('Y-m-d H:i:s');
            $this->db->insert('guest_details',$gd_insert_data);


            $p_insert_data['wr_id'] = $last_id;
        	$p_insert_data['e_id'] = $this->session->userdata('admin_id');
        	$p_insert_data['payment_purpose'] = 'Advance Payment';
            $p_insert_data['payment_mode'] = $input_data['payment_mode'];
            $p_insert_data['p_amount'] = $input_data['adv_amount'];
        	$p_insert_data['p_date'] = date('Y-m-d H:i:s');
            $this->db->insert('payment',$p_insert_data);



            ///////////////Room Availibility ///////////////////////////
            $fetch_product = $this->db->select('*')->where('r_id',$input_data['r_id'])->get('rooms')->result_array();
            $quantity=$fetch_product[0]['available_room'];
            $new_quantity=$quantity-$input_data['num_rooms'];
            $edit_room_data['available_room'] = $new_quantity;	
            $this->db->where('r_id',$input_data['r_id']);
            $this->db->update('rooms',$edit_room_data);
            echo 'Success';
            if($input_data['coupon_code']){
            	$upd="UPDATE `coupon` SET `cp_quantity` = `cp_quantity`-1 WHERE `cp_code` = '".$coupon_code['coupon_code']."' ";
             	$query = $this->db->query($upd);
            }
		}
	}

	public function guest_checkin()
	{
		if(isAdmin())
		{
			$input_data = $this->input->post();


			$guest=0;
            foreach ($input_data['guest_name'] as $key => $guest_name) 
            {
        	/////// Document Upload ///////////////////////
    		$_FILES['userfile']['name']     = $_FILES['documents']['name'][$key];
	        $_FILES['userfile']['type']     = $_FILES['documents']['type'][$key];
	        $_FILES['userfile']['tmp_name'] = $_FILES['documents']['tmp_name'][$key];
	        $_FILES['userfile']['error']    = $_FILES['documents']['error'][$key];
	        $_FILES['userfile']['size']     = $_FILES['documents']['size'][$key];
			$config = array('upload_path' => "./uploads/documents/",
							'allowed_types' => "gif|jpg|png|jpeg",
							'overwrite' => TRUE,
							'encrypt_name' => TRUE
							);
			$this->load->library('upload', $config);
			$this->upload->initialize($config);
			if($this->upload->do_upload())
			{
				$data = array('upload_data' => $this->upload->data());
				$file_name=$data['upload_data']['file_name'];
				$insert_inv_data['documents'] = $file_name;
				$config["source_image"] = './uploads/documents/'.$file_name;
				$config['new_image'] = './uploads/documents/thumbnail/';
				$config['image_library']  = 'gd2';
				$config['create_thumb'] =  FALSE;
				$config['overwrite'] = TRUE;
				$config['maintain_ratio'] = FALSE;
				$config["width"] = 500;
				$config["height"] = 500;
				$this->load->library('image_lib', $config);
				$this->image_lib->initialize($config);
				$this->image_lib->resize();
				$this->image_lib->clear();
			}
        	/////// Guest Picture Upload ///////////////////////
    		$_FILES['userfile']['name']     = $_FILES['guest_picture']['name'][$key];
	        $_FILES['userfile']['type']     = $_FILES['guest_picture']['type'][$key];
	        $_FILES['userfile']['tmp_name'] = $_FILES['guest_picture']['tmp_name'][$key];
	        $_FILES['userfile']['error']    = $_FILES['guest_picture']['error'][$key];
	        $_FILES['userfile']['size']     = $_FILES['guest_picture']['size'][$key];
			$config = array('upload_path' => "./uploads/guest_picture/",
							'allowed_types' => "gif|jpg|png|jpeg",
							'overwrite' => TRUE,
							'encrypt_name' => TRUE
							);
			$this->load->library('upload', $config);
			$this->upload->initialize($config);
			if($this->upload->do_upload())
			{
				$data = array('upload_data' => $this->upload->data());
				$guestPicture=$data['upload_data']['file_name'];
				$insert_inv_data['guest_picture'] = $guestPicture;
				$config["source_image"] = './uploads/guest_picture/'.$guestPicture;
				$config['new_image'] = './uploads/guest_picture/thumbnail/';
				$config['image_library']  = 'gd2';
				$config['create_thumb'] =  FALSE;
				$config['overwrite'] = TRUE;
				$config['maintain_ratio'] = FALSE;
				$config["width"] = 500;
				$config["height"] = 500;
				$this->load->library('image_lib', $config);
				$this->image_lib->initialize($config);
				$this->image_lib->resize();
				$this->image_lib->clear();
			}
			if ($input_data['guest_age'][$key]>10) {
			
            $guest++;
        	}
        	$insert_inv_data['wr_id'] = $input_data['wr_id'];
        	$insert_inv_data['guest_name'] = $guest_name;
        	$insert_inv_data['guest_phone'] = $input_data['guest_phone'][$key];
        	$insert_inv_data['guest_age'] = $input_data['guest_age'][$key];
        	$insert_inv_data['guest_address'] = $input_data['guest_address'][$key];
        	$insert_inv_data['documents_type'] = $input_data['documents_type'][$key];
        	$insert_inv_data['document_number'] = $input_data['document_number'][$key];
        	$insert_inv_data['check_in_time'] = date('d-m-y H:i:s');
            $this->db->insert('walk_in_guest',$insert_inv_data);
            }

            $upd_reservation="UPDATE `walk_in_reservation` SET `num_guest` = `num_guest`+$guest WHERE `wr_id` = '".$input_data['wr_id']."'";
            $query_reservation = $this->db->query($upd_reservation);
			$guest_details = $this->db->where('wr_id', $input_data['wr_id'])->order_by('gd_id','desc')->get('guest_details')->result_array();
			$data = $this->db->where('r_id', $guest_details['0']['gd_room_type'])->get('rooms')->result_array();


//print_r($rooms_details);

  $num_gust=$guest_details['0']['gd_check_in']+$guest;
$extra_bed_price=0;
if($num_gust>2)
{
$extra_guest=$num_gust-2;

	 $extra_guest=$extra_guest/2;

 $total_extra_bed=ceil($extra_guest);
}

  $extra_bed_price=$total_extra_bed*$data[0]['extra_bed'];

			$total_amount=$data[0]['r_price']+$extra_bed_price;
			 $edit_data['gd_check_in'] = $num_gust;
			 $edit_data['gd_amount'] = $total_amount;
	        	
	            $this->db->where('wr_id',$input_data['wr_id']);
	            $this->db->order_by('gd_id','desc');
	            $this->db->limit(1);

	            $this->db->update('guest_details',$edit_data);
	            //echo 'success';
		
		}
	}
	public function Edit_data()
	{
	    if(isAdmin())
	    {  
	        	$input_data = $this->input->post();
	            $input_data = $this->security->xss_clean($input_data);
	            $edit_data['rc_name'] = $input_data['rc_name'];
	        	
	            $this->db->where('rc_id',$input_data['rc_id']);
	            $this->db->update('room_category',$edit_data);
	            echo 'Success';
	    }      
	}
	public function checkout()
	{
	    if(isAdmin())
	    {  
	        	$input_data = $this->input->post();
	            $input_data = $this->security->xss_clean($input_data);


	            $guest_details=$this->db->where('wr_id',$input_data['id'])->order_by('gd_id','desc')->get('guest_details')->result_array();
	            if ($guest_details[0]['gd_check_in']>1) {
	            
	            $edit_data['check_status'] = 'Check Out';
        		$edit_data['check_out_time'] = date('d-m-y H:i:s');
	        	
	            $this->db->where('wg_id',$input_data['checkin_id']);
	            $this->db->update('walk_in_guest',$edit_data);


	            if ($input_data['guest_age']>10) {


	             $upd_checkin="UPDATE `guest_details` SET `gd_check_in` = `gd_check_in`-1 WHERE `wr_id` = '".$input_data['id']."' ORDER BY gd_id DESC LIMIT 1 ";
            	$query = $this->db->query($upd_checkin);

	            $upd_checkout="UPDATE `guest_details` SET `gd_check_out` = `gd_check_out`+1 WHERE `wr_id` = '".$input_data['id']."' ORDER BY gd_id DESC LIMIT 1 ";
            	$query_checkout = $this->db->query($upd_checkout);

	            $upd_reservation="UPDATE `walk_in_reservation` SET `num_guest` = `num_guest`-1 WHERE `wr_id` = '".$input_data['id']."'";
            	$query_reservation = $this->db->query($upd_reservation);
	        	
	            }
	            echo 'Successfully Check out';
	        }
	        else
	        {
	        	echo 'You cant Check out';
	        }

	            
	    }      
	}
	public function package_upgrade()
	{
	    if(isAdmin())
	    {  
	        	$input_data = $this->input->post();
	            $input_data = $this->security->xss_clean($input_data);

	            $booking_deatils=$this->db->where('wr_id',$input_data['wr_id'])->get('walk_in_reservation')->result_array();
	            $guest_details=$this->db->where('wr_id',$input_data['wr_id'])->order_by('gd_id','desc')->get('guest_details')->result_array();
	            $rooms_details=$this->db->where('r_id',$input_data['r_id'])->get('rooms')->result_array();

	            

	            if ($booking_deatils[0]['room_number']<$input_data['room_numbers']) {



	            

	            $num_guest=$guest_details[0]['gd_check_in'];

	            $extra_bed_price=0;
	            $gd_amount=0;
				if($num_guest>2)
				{
				$extra_guest=$num_guest-2;
				$extra_guest=$extra_guest/2;
				$total_extra_bed=ceil($extra_guest);
				}
				 $extra_bed_price=$total_extra_bed*$rooms_details[0]['extra_bed'];

				$total_amount=$rooms_details[0]['r_price']+$extra_bed_price;




				$start = $booking_deatils[0]['check_in_time'];
                $last_upgrade_time=date('H:i',strtotime('+2 hour',strtotime($start)));

                $curr_time=date('H:i');

                if ($last_upgrade_time<$curr_time) {
                
				$gd_amount=$guest_details[0]['gd_amount']/2;

	            $gd_edit_data['gd_amount'] =$gd_amount;
	        	
	            $this->db->where('gd_id',$guest_details[0]['gd_id']);
	            $this->db->update('guest_details',$gd_edit_data);



	            $wir_edit_data['check_in_time'] =date('H:i');
	            $wir_edit_data['check_out_time'] =date('H:i');
	        	
	            $this->db->where('wr_id',$guest_details[0]['wr_id']);
	            $this->db->update('guest_details',$wir_edit_data);









	        	}
	        	else
	        	{
	        	$this->db->where('gd_id',$guest_details[0]['gd_id']);
	            $this->db->delete('guest_details');

	        	}

	            $r_edit_data['room_status'] ='Check out';
	        	
	            $this->db->where('room_number',$booking_deatils[0]['room_number']);
	            $this->db->update('room_numbers',$r_edit_data);



	            $rn_edit_data['room_status'] ='Check In';
	        	
	            $this->db->where('room_number',$input_data['room_numbers']);
	            $this->db->update('room_numbers',$rn_edit_data);





	            $insert_data['wr_id'] = $input_data['wr_id'];
	            $insert_data['gd_check_in'] = $num_guest;
	            $insert_data['gd_check_out'] = 0;
	            $insert_data['gd_amount'] = $total_amount;
	            $insert_data['gd_room_type'] = $input_data['r_id'];
	            $insert_data['gd_date'] = date('Y-m-d H:i:s');
	        	
	            $this->db->insert('guest_details',$insert_data);



	            $edit_data['total_amount'] = $total_amount;
	            $edit_data['r_id'] = $input_data['r_id'];
	            $edit_data['room_number'] = $input_data['room_numbers'];
	        	
	            $this->db->where('wr_id',$input_data['wr_id']);
	            $this->db->update('walk_in_reservation',$edit_data);
	            echo 'success';
	        	}
	        	else
	        	{
	        	echo 'failed';

	        	}
	    }      
	}
	public function Delete()
    {
        if(isAdmin())
        {
        	$input_data = $this->input->post();
        	$this->db->where('rc_id', $input_data['id']);
			$this->db->delete('room_category');
             // / ---------------------------Insert Audit trail--------------------
            $audit_trail_table='audit_trail';
	        $audit_trail_array=array(
	                                    'user_name'=>$this->session->userdata('admin_name'),
	                                    'action'=>'Action -> "Delete Rooms"',
	                                    'action_time'=>date('Y-m-d H:i:s')
	                                );
        	$this->CommonModel->insert($audit_trail_table,$audit_trail_array);
        }
    }

    public function export()
	{
		if(isAdmin())
		{ 
			$project_array=$this->db->get('room_category')->result_array();
			header("Content-type: application/csv");
		    header("Content-Disposition: attachment; filename=\"rooms-".date('d-m-Y').".csv\"");
		    header("Pragma: no-cache");
		    header("Expires: 0");

		     $handle = fopen('php://output', 'w');
			$excel_heding=array();
			array_push($excel_heding, 'SL', 'Rooms Name',  'Status');
			fputcsv($handle, $excel_heding);
			foreach ($project_array as $key => $project_data) {
			$export_req = array();
			if ($project_data['cat_status']=='1') {
			$status='Active';
			}
			else
			{
			$status='Inactive';
			}
			array_push($export_req, $key+1, $project_data['rc_name'], $status);

			//print_r($call_det);die;
			fputcsv($handle, $export_req);
			} 
			 fclose($handle);
		     exit;
		
		}
	}
	public function import(){

        $data = array();

        $memData = array();

                $insertCount = $updateCount = $rowCount = $notAddCount = 0;

                if(is_uploaded_file($_FILES['import_data']['tmp_name'])){

                    $this->load->library('CSVReader');

                    $csvData = $this->csvreader->parse_csv($_FILES['import_data']['tmp_name']);

                    if(!empty($csvData)){

                        foreach($csvData as $row){ 
                        	$rowCount++;
                        	
							$insert_data['Rooms_code'] = $row['Rooms Code'];
							$insert_data['e_name'] = $row['Name'];
							$insert_data['e_email'] = $row['Email ID'];
							$insert_data['e_mobile'] = $row['Mobile Number'];
							$insert_data['e_address'] = $row['Address'];
							$insert_data['e_password'] = $row['Password'];
							$insert_data['e_status'] = '1';
							$insert_data['join_date'] = date('Y-m-d H:i:s');
							
							$this->db->insert('Rooms',$insert_data);						
							
                          $insertCount++;  

                        }
                        $notAddCount = ($rowCount - ($insertCount + $updateCount));
                    }
                }

    }
    public function details()
	{
	    if(isAdmin())
	    {  
	        	$input_data = $this->input->post();
	            $input_data = $this->security->xss_clean($input_data);
	            ?>
	            <table id="myTable" class="display table" style="width:100%">
				<tbody >
				<?php
				$booking_deatils=$this->db->where('wr_id',$input_data['wr_id'])->get('walk_in_reservation')->result_array();
				$room=$this->db->where('r_id',$booking_deatils[0]['r_id'])->get('rooms')->result_array();
				$payment_details=$this->db->where('wr_id',$booking_deatils[0]['wr_id'])->get('payment')->result_array();
				$guest_details=$this->db->where('wr_id',$booking_deatils[0]['wr_id'])->order_by('gd_date','asc')->get('guest_details')->result_array();
				$grand_total_amount=0;
				$total_payment=0;
				foreach ($payment_details as $key => $payment_data) {
				$total_payment=$total_payment+$payment_data['p_amount'];
				}
				?>
				<tr>
				<td> Guest Picture</td>
				<td class="center"><img src="<?php echo base_url(); ?>uploads/guest_picture/<?php echo $booking_deatils[0]['guest_picture']; ?>"  width="300"></td>
				</tr>
				<tr>
				<td> Booking Code</td>
				<td class="center"><a href="#"><?php echo $booking_deatils[0]['booking_code']; ?></a></td>
				</tr>
				<tr>
				<td>Num Guest</td>
				<td class="center"><?php echo $booking_deatils[0]['num_guest']; ?><br></td>
				</tr>
				<tr>
				<td>Num Rooms</td>
				<td class="center"><?php echo $booking_deatils[0]['num_rooms']; ?><br></td>
				</tr>
				<tr>
				<td>Extra Bed</td>
				<td class="center"><?php echo $booking_deatils[0]['extra_bed']; ?><br></td>
				</tr>
				<tr>
				<td>Check In</td>
				<td class="center"><?php echo $booking_deatils[0]['check_in']; ?> <?php echo $booking_deatils[0]['check_in_time']; ?><br></td>
				</tr>
				<tr>
				<td>Check Out</td>
				<td class="center"><?php echo $booking_deatils[0]['check_out']; ?> <?php echo $booking_deatils[0]['check_out_time']; ?><br></td>
				</tr>
				<tr>
				<td>Visit Purpose</td>
				<td class="center"><?php echo $booking_deatils[0]['wr_visit_purpose']; ?><br></td>
				</tr>

				<?php  
				$shift_details=$this->db->where('wr_id',$booking_deatils[0]['wr_id'])->get('room_shift')->result_array();
				$total_shift=sizeof($shift_details);
				if ($total_shift>0) {
				
				?>
				<tr>
				<td>Shift Details</td>
				<td class="center" >
					<?php foreach ($shift_details as $key => $shift_data) {	?>
					<?php echo $shift_data['from_room_number'].'-'.$shift_data['to_room_number']; ?><br>

				<?php } ?>
				</td>
				</tr>
				<?php } ?>
				<tr>
				<td>Room</td>
				<td class="center"><b style="cursor: pointer;"><?php echo $room[0]['r_type']; ?></b><?php if($booking_deatils[0]['status']=='1'){ ?><button onclick="package_upgrade(<?php echo $input_data['wr_id']; ?>)" class="btn btn-success" type="button">Change</button><?php } ?><br></td>
				</tr>
				<?php  
				if (sizeof($guest_details)>0) {
				
				?>
				<tr>
				<td>Tarif Details</td>
				<td class="center">
					<?php  

				foreach ($guest_details as $key => $guest_data) {
				$grand_total_amount=$grand_total_amount+$guest_data['gd_amount'];
				//if ($key==0) {
					echo $guest_data['gd_date'].'-'.$guest_data['gd_amount'].'<br>';
				// }
				// else
				// {
				// 	echo '+'.$guest_data['gd_amount'];

				// }

				}
					?>
					

					<br></td>
				</tr>
			<?php } ?>
				<tr>
				<td>Total Amount</td>
				<td class="center">
					
					<?php  
						$hotel_tax = $grand_total_amount * ( 12 /100 );
					?>
					Sub Total- <?php echo $grand_total_amount; ?><br>
					CGST (6%)- <?php echo $hotel_tax/2; ?><br>
					SGST (6%)- <?php echo $hotel_tax/2; ?><br>
					Grand Total- <?php echo $grand_total_amount+$hotel_tax; ?><br>
				</td>
				</tr>
				<tr>
				<td>Advance Details</td>
				<td class="center"  >
				<?php foreach ($payment_details as $key => $payment_data) {
				// $total_payment=$total_payment+$payment_data['p_amount'];
				
				
				echo date('d-m-Y',strtotime($payment_data['p_date'])).' '.$payment_data['p_amount'].'('.$payment_data['payment_mode'].')';
				echo '<br>';
				
				} ?>
				<a class="btn btn-success" href="<?php echo base_url(); ?>Reservation/receipt_print/<?php echo $booking_deatils[0]['wr_id']; ?>">Print</a>
				</td>
				</tr>
				<tr>
				<tr>
				<td>Advance Amount</td>
				<td class="center">
					
					<b style="cursor: pointer;"><?php echo $total_payment; ?></b> <?php if($booking_deatils[0]['status']=='1'){ ?><button onclick="advance_payment(<?php echo $input_data['wr_id']; ?>)" type="button" class="btn btn-success">Pay More</button><?php } ?><br>

				</td>
				</tr>
				<tr>
				<td>Payments Mode</td>
				<td class="center"><?php echo $booking_deatils[0]['payment_mode']; ?><br></td>
				</tr>
				<tr>
				<td>Coming From</td>
				<td class="center"><?php echo $booking_deatils[0]['coming_from']; ?><br></td>
				</tr>
				<tr>
				<td>Going To</td>
				<td class="center"><?php echo $booking_deatils[0]['going_to']; ?><br></td>
				</tr>
				<tr>
				<td>Booking source</td>
				<td class="center"><?php echo $booking_deatils[0]['booking_source']; ?><br></td>
				</tr>
				<tr>
				<td>Guest Type</td>
				<td class="center"><?php echo $booking_deatils[0]['guest_type']; ?><br></td>
				</tr>
				<?php if ($booking_deatils[0]['coupon_code']!='') { ?>
				<tr>
				<td>Discount</td>
				<td class="center"><?php echo $booking_deatils[0]['discount']; ?><br></td>
				</tr>
				<tr>
				<td>Booking source</td>
				<td class="center"><?php echo $booking_deatils[0]['coupon_code']; ?><br></td>
				</tr>
				<?php } ?>


				</tbody>
				</table>
	            <?php
	    }      
	}
    public function details_old()
	{
	    if(isAdmin())
	    {  
	        	$input_data = $this->input->post();
	            $input_data = $this->security->xss_clean($input_data);
	            ?>
	            <table id="myTable" class="display table" style="width:100%">
				<tbody >
				<?php
				$booking_deatils=$this->db->where('wr_id',$input_data['wr_id'])->get('walk_in_reservation')->result_array();
				$room=$this->db->where('r_id',$booking_deatils[0]['r_id'])->get('rooms')->result_array();
				$payment_details=$this->db->where('wr_id',$booking_deatils[0]['wr_id'])->get('payment')->result_array();
				$guest_details=$this->db->where('wr_id',$booking_deatils[0]['wr_id'])->get('guest_details')->result_array();
				$grand_total_amount=0;
				$total_payment=0;
				foreach ($payment_details as $key => $payment_data) {
				$total_payment=$total_payment+$payment_data['p_amount'];
				}
				?>
				<tr>
				<td> Guest Picture</td>
				<td class="center"><img src="<?php echo base_url(); ?>uploads/guest_picture/<?php echo $booking_deatils[0]['guest_picture']; ?>"  width="300"></td>
				</tr>
				<tr>
				<td> Booking Code</td>
				<td class="center"><a href="#"><?php echo $booking_deatils[0]['booking_code']; ?></a></td>
				</tr>
				<tr>
				<td>Num Guest</td>
				<td class="center"><?php echo $booking_deatils[0]['num_guest']; ?><br></td>
				</tr>
				<tr>
				<td>Num Rooms</td>
				<td class="center"><?php echo $booking_deatils[0]['num_rooms']; ?><br></td>
				</tr>
				<tr>
				<td>Extra Bed</td>
				<td class="center"><?php echo $booking_deatils[0]['extra_bed']; ?><br></td>
				</tr>
				<tr>
				<td>Check In</td>
				<td class="center"><?php echo $booking_deatils[0]['check_in']; ?> <?php echo $booking_deatils[0]['check_in_time']; ?><br></td>
				</tr>
				<tr>
				<td>Check Out</td>
				<td class="center"><?php echo $booking_deatils[0]['check_out']; ?> <?php echo $booking_deatils[0]['check_out_time']; ?><br></td>
				</tr>
				<tr>
				<td>Visit Purpose</td>
				<td class="center"><?php echo $booking_deatils[0]['wr_visit_purpose']; ?><br></td>
				</tr>
				<tr>
				<td>Room</td>
				<td class="center" onclick="package_upgrade(<?php echo $input_data['wr_id']; ?>)"><?php echo $room[0]['r_type']; ?><br></td>
				</tr>
				<tr>
				<td>Total Amount</td>
				<td class="center">
					<?php  

				foreach ($guest_details as $key => $guest_data) {
				$grand_total_amount=$grand_total_amount+$guest_data['gd_amount'];
				if ($key==0) {
					echo $guest_data['gd_amount'];
				}
				else
				{
					echo '+'.$guest_data['gd_amount'];

				}

				}
					?>
					

					<br></td>
				</tr>
				<tr>
				<td>Advance Amount</td>
				<td class="center"  onclick="advance_payment(<?php echo $input_data['wr_id']; ?>)"><?php echo $total_payment; ?><br></td>
				</tr>
				<tr>
				<td>Payments Mode</td>
				<td class="center"><?php echo $booking_deatils[0]['payment_mode']; ?><br></td>
				</tr>
				<tr>
				<td>Coming From</td>
				<td class="center"><?php echo $booking_deatils[0]['coming_from']; ?><br></td>
				</tr>
				<tr>
				<td>Going To</td>
				<td class="center"><?php echo $booking_deatils[0]['going_to']; ?><br></td>
				</tr>
				<tr>
				<td>Booking source</td>
				<td class="center"><?php echo $booking_deatils[0]['booking_source']; ?><br></td>
				</tr>
				<tr>
				<td>Guest Type</td>
				<td class="center"><?php echo $booking_deatils[0]['guest_type']; ?><br></td>
				</tr>
				<?php if ($booking_deatils[0]['coupon_code']!='') { ?>
				<tr>
				<td>Discount</td>
				<td class="center"><?php echo $booking_deatils[0]['discount']; ?><br></td>
				</tr>
				<tr>
				<td>Booking source</td>
				<td class="center"><?php echo $booking_deatils[0]['coupon_code']; ?><br></td>
				</tr>
				<?php } ?>


				</tbody>
				</table>
	            <?php
	    }      
	}
    public function guest_details()
	{
	    if(isAdmin())
	    {  
	        	$input_data = $this->input->post();
	            $input_data = $this->security->xss_clean($input_data);
	            ?>
	            <table id="myTable" class="display table" style="width:100%">
				<tbody >
				<?php
				$sl=0;
				$wr_deatils=$this->db->where('wr_id',$input_data['wr_id'])->get('walk_in_reservation')->result_array();
				$booking_deatils=$this->db->where('wr_id',$input_data['wr_id'])->get('walk_in_guest')->result_array();
				foreach ($booking_deatils as $key_data) {
				$sl++;
				?>
				<tr>
				<td>Guest - <?php echo $sl; ?></td>
				<td class="center"><?php echo $key_data['guest_name']; ?>(<?php echo $key_data['check_status']; ?>)&emsp; <?php if($key_data['check_status']!='Check Out'){ ?> <button type="button" class="btn  btn-danger  btn-xs" onclick="checkout_guest(<?php echo  $input_data['wr_id']; ?>,<?php echo  $key_data['wg_id']; ?>,<?php echo  $key_data['guest_age']; ?>);">Check Out</button> <?php } ?> </i>
                    </a></td>
				</tr>
				<tr>
				<td>Check In And Check Out</td>
				<td class="center"><?php echo $wr_deatils[0]['check_in']; ?> - <?php echo $wr_deatils[0]['check_out']; ?><br></td>
				</tr>
				<tr>
				<td>Mobile</td>
				<td class="center"><?php echo $key_data['guest_phone']; ?><br></td>
				</tr>
				<tr>
				<td>Age</td>
				<td class="center"><?php echo $key_data['guest_age']; ?><br></td>
				</tr>
				<tr>
				<td>Address</td>
				<td class="center"><?php echo $key_data['guest_address']; ?><br></td>
				</tr>
				<tr>
				<td>Document</td>
				<td class="center"><?php echo $key_data['documents_type']; ?>-<?php echo $key_data['document_number']; ?><br></td>
				</tr>
				<tr>
				<td> Documents - </td>
				<td class="center"><img src="<?php echo base_url(); ?>uploads/documents/<?php echo $key_data['documents']; ?>"  width="300"></td>
				</tr>
				<?php if ($key_data['guest_picture']!='') {
				 ?>
				<tr>
				<td> Guest Picture - </td>
				<td class="center"><img src="<?php echo base_url(); ?>uploads/guest_picture/<?php echo $key_data['guest_picture']; ?>"  width="300"></td>
				</tr>
			<?php } ?>
				<?php
				}
				?>


				</tbody>
				</table>
	            <?php
	    }      
	}
	public function new_billing($wr_id)
	{
		if(isAdmin())
		{
			$data['recordSet']=$this->db->where('wr_id',$wr_id)->get('walk_in_reservation')->result_array();
			$data['content'] = 'Reservation/generate_billing';
			$this->load->view('layout_home', $data);
		}
	}
	
	public function billing_save()
    {
        if(isAdmin())
        {
            $input_data = $this->input->post();
            $input_data = $this->security->xss_clean($input_data);
            $state_code = substr($input_data['gst'], 0, 2);
            
            $edit_data['room_status'] = 'Available';
            // $edit_data['room_status'] = 'Check out';
        	
            $this->db->where('room_number',$input_data['room_num']);
            $this->db->update('room_numbers',$edit_data);


            $edit_rerservation['check_out'] = date('Y-m-d');
            $edit_rerservation['check_out_time'] = date('H:i');
            $edit_rerservation['room_available'] = 1;
            $edit_rerservation['gst'] = $input_data['tax_type'];
            $edit_rerservation['total_amount'] = $input_data['subtotal'];
            $edit_rerservation['status'] = 0;
        	
            $this->db->where('wr_id',$input_data['wr_id']);
            $this->db->update('walk_in_reservation',$edit_rerservation);


            $insert_data['wr_id'] = $input_data['wr_id'];            
        	$insert_data['e_id'] = $this->session->userdata('admin_id');
            $insert_data['bill_no'] = $input_data['bill_no'];
            $insert_data['cus_name'] = $input_data['cus_name'];
            $insert_data['cus_phone'] = $input_data['cus_phone'];
            $insert_data['cus_email'] = $input_data['cus_email'];
            $insert_data['cus_address'] = $input_data['cus_address'];
            $insert_data['room_type'] = $input_data['room_type'];
            $insert_data['room_num'] = $input_data['room_num'];
            $insert_data['check_in_date'] = $input_data['check_in_date'];
            $insert_data['no_of_days'] = $input_data['no_of_days'];
            $insert_data['payment_mode'] = $input_data['payment_mode'];
            $insert_data['tax_type'] = $input_data['tax_type'];
            $insert_data['gst'] = $input_data['gst'];
            $insert_data['company_name'] = $input_data['company_name'];
            $insert_data['rent_amount'] = $input_data['rent'];
            $insert_data['extrabed_amount'] = $input_data['extrabed_amount'];
            $insert_data['discount'] = $input_data['discount'];
            $insert_data['hotel_tax'] = $input_data['hotel_tax'];
            $insert_data['food_tax'] = $input_data['food_tax'];
            $insert_data['advance_payment'] = $input_data['advance_payment'];
            $insert_data['subtotal'] = $input_data['subtotal'];
            $insert_data['net_amount'] = $input_data['net_amount'];
            $insert_data['gst_percenttage'] = 12;
            $insert_data['state_code'] = $state_code;
            $insert_data['note'] = $input_data['note'];
            $insert_data['date'] = date('Y-m-d H:i:s');
            $this->db->insert('reservation_billing',$insert_data);
            $last_id=$this->db->insert_id();



            $p_insert_data['wr_id'] = $input_data['wr_id']; 
        	$p_insert_data['e_id'] = $this->session->userdata('admin_id');
        	$p_insert_data['payment_purpose'] = 'Final Adjustment';
            $p_insert_data['payment_mode'] = $input_data['payment_mode'];
            $p_insert_data['p_amount'] = $input_data['net_amount'];
        	$p_insert_data['p_date'] = date('Y-m-d H:i:s');
            $this->db->insert('payment',$p_insert_data);




            $edit_payment['room_stay'] = 1;
        	
            $this->db->where('wr_id',$input_data['wr_id']);
            $this->db->update('payment',$edit_payment);




            $edit_guest_details['room_stay'] = 1;
        	
            $this->db->where('wr_id',$input_data['wr_id']);
            $this->db->update('guest_details',$edit_guest_details);


            $editguest['check_status'] = 'Check Out';
        	
            $this->db->where('wr_id',$input_data['wr_id']);
            $this->db->update('walk_in_guest',$editguest);

            echo $input_data['wr_id'];
            // if ($input_data['itemName'][0]!='') {
            
            // foreach ($input_data['itemName'] as $key => $rate_data) {
            //     $insert_bill_data['billing_id'] = $last_id;
            //     $insert_bill_data['item_name'] = $input_data['itemName'][$key];
            //     $insert_bill_data['sl_no'] = $input_data['slno'][$key];
            //     $insert_bill_data['mrp'] = $input_data['price'][$key];
            //     $insert_bill_data['price'] = $input_data['price'][$key];
            //     $insert_bill_data['quantity'] = $input_data['qty'][$key];
            //     $insert_bill_data['unit'] = $input_data['unit'][$key];
            //     $insert_bill_data['description'] = '';
            //     $this->db->insert('reservation_billing_data',$insert_bill_data);
            // $q=$input_data['qty'][$key];
            // }
        	// }
        }
    }
	public function advanve_payment()
    {
        if(isAdmin())
        {
            $input_data = $this->input->post();
            $input_data = $this->security->xss_clean($input_data);
            


            $insert_data['wr_id'] = $input_data['wr_id'];            
        	$insert_data['e_id'] = $this->session->userdata('admin_id');
            $insert_data['payment_purpose'] = 'Advance Payment';
            $insert_data['payment_mode'] = $input_data['payment_mode'];
            $insert_data['p_amount'] = $input_data['advance_payment'];
            $insert_data['p_date'] = date('Y-m-d H:i:s');
            $this->db->insert('payment',$insert_data);
            echo 'success';
            
        }
    }

}