<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Report extends CI_Controller {

	function __construct() 
	{
        error_reporting(0);
        parent::__construct();
        $this->load->model('CommonModel');
        $this->load->helper('Security');
        $this->load->library('form_validation');
        $this->load->model('Report_model');

       
    }
    public function index() {
        // Default report: last 30 days
        $start = $this->input->get('start_date') ?? date('Y-m-01');
        $end   = $this->input->get('end_date') ?? date('Y-m-t');
        $sport = $this->input->get('sport') ?? '';
        $status = $this->input->get('status') ?? '';

        $data['start_date'] = $start;
        $data['end_date']   = $end;
        $data['sport']      = $sport;
        $data['status']     = $status;

        $data['sports'] = $this->Report_model->get_all_sports();
        $data['report'] = $this->Report_model->get_report($start, $end, $sport, $status);
        $data['summary'] = $this->Report_model->get_summary($start, $end, $sport, $status);

        $data['content'] = 'Report/index';
		$this->load->view('layout_home', $data);
    }
}