<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class OpdAppointmentBooking extends CI_Controller {

	function __construct() 
	{
        error_reporting(0);
        parent::__construct();
        $this->load->model('CommonModel');
        $this->load->helper('Security');
        $this->load->library('form_validation');

       
    }

	public function index()
	{ 
		if(isAdmin())
		{ 
			$data['recordSet']=$this->db->order_by('oad_id','desc')->get('opd_appointment_details')->result_array();
			$data['content'] = 'HospitalService/OpdBookingListing';
			$this->load->view('layout_home', $data);
		}
	}
	public function update_status() {
	    $oad_id = $this->input->post('oad_id');
	    $status = $this->input->post('status');

	    // Update without using a model
	    $this->db->where('oad_id', $oad_id);
	    $updated = $this->db->update('opd_appointment_details', ['status' => $status]);

	    if ($updated) {
	        echo 'success';
	    } else {
	        http_response_code(500);
	        echo 'error';
	    }
	}


	public function add()
	{
		if(isAdmin())
		{
			$data['content'] = 'HealthCheckup/Add';
			$this->load->view('layout_home', $data);
		}
	}
	public function get_sub_cat()
	{
		if(isAdmin())
		{
			$input_data = $this->input->post();
            $input_data = $this->security->xss_clean($input_data);

			$data_category=$this->db->where('cat_id', $input_data['cat_id'])->get('sub_category')->result_array();
			?>
			<div class="form-group">
                <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12">
                    <label>Sub Category</label>
                    <select  name="sub_cat_id" id="sub_cat_id" class="form-control" >
                    	<option value="0">Choose Any one</option>
			            <?php foreach($data_category as $category){ ?>
			            <option value="<?php echo  $category['sub_cat_id']; ?>"><?php echo  $category['sub_cat_name']; ?></option>
			            <?php } ?>
                    </select><br>
                </div>
	        </div>
			<?php
		}
	}
	public function edit($hc_id)
	{
		if(isAdmin())
		{
			$hc_test = $this->db->get_where('health_checkup_tests', ['hc_id' => $hc_id])->result_array();
		    $hcrm = $this->db->get_where('health_checkup_report_measure', ['hc_id' => $hc_id])->result_array();
		    $health_checkup = $this->db->where('hc_id',$hc_id)->get('health_checkup')->result_array();

		    $data = [
		        'hc_test' => $hc_test,
		        'hcrm' => $hcrm,
		        'health_checkup' => $health_checkup
		    ];
            $data['content']  ="HealthCheckup/Edit";
            $this->load->view('layout_home',$data);
		}
	}
	public function save()
	{
		if(isAdmin())
		{
			$input_data = $this->input->post();
            $input_data = $this->security->xss_clean($input_data);
            
            	$insert_data['hc_name'] = $input_data['hc_name'];
            	$insert_data['total_price'] = $input_data['total_price'];
            	$insert_data['pay_amount'] = $input_data['pay_amount'];
            	$insert_data['test_for'] = $input_data['test_for'];
            	$insert_data['test_preparation'] = $input_data['test_preparation'];
            	$insert_data['get_reports'] = $input_data['get_reports'];
	            $this->db->insert('health_checkup',$insert_data);
	            $last_id=$this->db->insert_id();
	            //////////////////////Test Add/////////////////////////////////////
	            foreach ($input_data['test_name'] as $key => $timing) 
	            {

            	$insert_timing['hc_id'] = $last_id;
            	$insert_timing['test_name'] = $timing['name'];
	            $this->db->insert('health_checkup_tests',$insert_timing);
	            }
	            //////////////////////Smart Report Measure Add/////////////////////////////////////
	            foreach ($input_data['titles'] as $key => $srm) 
	            {

            	$insert_srm['hc_id'] = $last_id;
            	$insert_srm['title'] = $srm['title'];
            	$insert_srm['description'] = $srm['desc'];
	            $this->db->insert('health_checkup_report_measure',$insert_srm);
	            }
            echo 'Success';
        }
		
	}

	public function Edit_data()
	{
	    if(isAdmin())
	    {  
        	$input_data = $this->input->post();
            $input_data = $this->security->xss_clean($input_data);

            	$insert_data['hc_name'] = $input_data['hc_name'];
            	$insert_data['total_price'] = $input_data['total_price'];
            	$insert_data['pay_amount'] = $input_data['pay_amount'];
            	$insert_data['test_for'] = $input_data['test_for'];
            	$insert_data['test_preparation'] = $input_data['test_preparation'];
            	$insert_data['get_reports'] = $input_data['get_reports'];
	            $this->db->where('hc_id',$input_data['hc_id']);
	            $this->db->update('health_checkup',$insert_data);

	            $this->db->where('hc_id', $input_data['hc_id'])->delete('health_checkup_tests');
	            $this->db->where('hc_id', $input_data['hc_id'])->delete('health_checkup_report_measure');

	            //////////////////////Test Add/////////////////////////////////////
	            foreach ($input_data['test_name'] as $key => $timing) 
	            {

            	$insert_timing['hc_id'] = $input_data['hc_id'];
            	$insert_timing['test_name'] = $timing['name'];
	            $this->db->insert('health_checkup_tests',$insert_timing);
	            }
	            //////////////////////Smart Report Measure Add/////////////////////////////////////
	            foreach ($input_data['titles'] as $key => $srm) 
	            {

            	$insert_srm['hc_id'] = $input_data['hc_id'];
            	$insert_srm['title'] = $srm['title'];
            	$insert_srm['description'] = $srm['desc'];
	            $this->db->insert('health_checkup_report_measure',$insert_srm);
	            }
	            echo 'success';
	    }      
	}
	public function status_change()
	{
	    if(isAdmin())
	    {  
	        	$input_data = $this->input->post();
	            $input_data = $this->security->xss_clean($input_data);
	        	$edit_data['status'] = $input_data['new_status'];
	        	
	            $this->db->where('prd_id',$input_data['id']);
	            $this->db->update('product',$edit_data);
	            echo 'success';
	    }      
	}

	public function Delete()
    {
        if(isAdmin())
        {
        	$input_data = $this->input->post();
        	$this->db->where('hcb_id', $input_data['id']);
			$this->db->delete('health_checkup_booking');
             // / ---------------------------Insert Audit trail--------------------
            $audit_trail_table='audit_trail';
	        $audit_trail_array=array(
	                                    'user_name'=>$this->session->userdata('admin_name'),
	                                    'action'=>'Action -> "Delete HealthCheckup"',
	                                    'action_time'=>date('Y-m-d H:i:s')
	                                );
        	$this->CommonModel->insert($audit_trail_table,$audit_trail_array);
        }
    }


	public function review_delete()
    {
        if(isAdmin())
        {
        	$input_data = $this->input->post();
        	$this->db->where('rev_id', $input_data['id']);
			$this->db->delete('review');
        }
    }

    public function export()
	{
		if(isAdmin())
		{ 
			$project_array=$this->db->select('d.prd_id,d.vt_id,d.project_id,d.d_code,d.d_name,d.working_project,d.d_pass,d.date,vt.vehicle_type, p.project_code, p.project_name')->from('product as d')->join('project as p', 'd.project_id = p.project_id', 'LEFT')->join('vehicle_type as vt', 'd.vt_id = vt.vt_id', 'LEFT')->order_by('prd_id','desc')->get()->result_array();
			header("Content-type: application/csv");
		    header("Content-Disposition: attachment; filename=\"product-".date('d-m-Y').".csv\"");
		    header("Pragma: no-cache");
		    header("Expires: 0");

		     $handle = fopen('php://output', 'w');
			$excel_heding=array();
			array_push($excel_heding, 'SL', 'SAP ID', 'Product Name', 'Working Project', 'Product Paassword', 'Vehicle Type', 'Status','Date');
			fputcsv($handle, $excel_heding);
			foreach ($project_array as $key => $project_data) {
			$export_req = array();
			if ($project_data['d_status']=='1') {
			$status='Active';
			}
			else
			{
			$status='Inactive';
			}
			$registered_data=date('Y-m-d', strtotime($project_data['date']));
			array_push($export_req, $key+1, $project_data['d_code'], $project_data['d_name'], $project_data['project_code'], $project_data['d_pass'], $project_data['vehicle_type'], $status, $registered_data);

			//print_r($call_det);die;
			fputcsv($handle, $export_req);
			} 
			 fclose($handle);
		     exit;
		
		}
	}

	public function import(){

        $data = array();

        $memData = array();

                $insertCount = $updateCount = $rowCount = $notAddCount = 0;

                if(is_uploaded_file($_FILES['import_data']['tmp_name'])){

                    $this->load->library('CSVReader');

                    $csvData = $this->csvreader->parse_csv($_FILES['import_data']['tmp_name']);
                    
                    if(!empty($csvData)){

                        foreach($csvData as $row){ 
                        	$rowCount++;
                        	$duplicate_data=$this->db->where('pin', $row['Project Code'])->get('active_pin')->result_array();
                        	// echo '<pre>';
                        	// print_r($row);
				            if(empty($duplicate_data))
				            {
							$insert_data['pin'] = $row['Project Code'];
							$insert_data['delevery_charge'] = $row['Delivery Charge'];
							
							$this->db->insert('active_pin',$insert_data);
							}

	
                          $insertCount++;  

                        }
                        $notAddCount = ($rowCount - ($insertCount + $updateCount));
                    }
                }

    }

}