<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Notification extends CI_Controller {

	function __construct() 
	{
        error_reporting(0);
        parent::__construct();
        $this->load->model('CommonModel');
        $this->load->helper('Security');
        $this->load->library('form_validation');
        header("Access-Control-Allow-Origin: *");
		header("Access-Control-Allow-Headers: Origin, X-Requested-With, Content-Type, Accept");
       
       
    }

	public function index()
	{ 
		if(isAdmin())
		{ 
			$data['recordSet']=$this->db->select('ca.n_id,ca.date,ca.note,ca.call_req_date, c.c_name, c.c_mobile, c.c_address,  e.employee_code, e.e_name')->from('notification as ca')->join('customer as c', 'ca.c_id = c.c_id', 'LEFT')->join('employee as e', 'ca.e_id = e.e_id', 'LEFT')->order_by('n_id','desc')->get()->result_array();
			$data['content'] = 'Notification/Listing';
			$this->load->view('layout_home', $data);
		}
	}
	public function data_details()
	{ 
		if(isAdmin())
		{ 
			$input_data = $this->input->post();
            $input_data = $this->security->xss_clean($input_data);
			$dumping_yard_details=$this->db->select('ca.ca_id,ca.c_id,ca.date,ca.assign_date, c.c_name, c.c_mobile, c.c_address,  e.employee_code, e.e_name')->from('notification as ca')->join('customer as c', 'ca.c_id = c.c_id', 'LEFT')->join('employee as e', 'ca.e_id = e.e_id', 'LEFT')->order_by('ca_id','desc')->get()->result_array();
		?>
		<div class="row">
          
          <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12">
          <div class="form-group">
              
                  <label>Customer</label>
                  <select class="form-control" name="c_id" required>
                      <option value="">Choose Customer</option>
                      <?php  
                      $customer_data=$this->db->get('customer')->result_array();
                      foreach ($customer_data as $customer_details) {
                       
                      ?>
                      <option value="<?php echo $customer_details['c_id']; ?>" <?php if($customer_details['c_id']==$dumping_yard_details['0']['c_id']){ echo 'selected'; } ?> ><?php echo $customer_details['c_name']; ?></option>
                    <?php } ?>
                  </select>
                  <br>
              </div>
          </div>
          <input type="hidden" name="ca_id" value="<?php echo $dumping_yard_details['0']['c_id']; ?>">
              <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12">
          <div class="form-group">
                  <label>Employee</label>
                  <select class="form-control" name="e_id" required>
                      <option value="">Employee</option>
                      <?php  
                      $meterial_data=$this->db->get('employee')->result_array();
                      foreach ($meterial_data as $meterial_details) {
                       
                      ?>
                      <option value="<?php echo $meterial_details['e_id']; ?>" <?php if($meterial_details['e_id']==$dumping_yard_details['0']['e_id']){ echo 'selected'; } ?> ><?php echo $meterial_details['employee_code']; ?></option>
                    <?php } ?>
                  </select>
                  <br>
              </div>
          </div>
          </div>

		<?php
		}
	}

	public function add()
	{
		if(isAdmin())
		{
			$data['content'] = 'notification/Add';
			$this->load->view('layout_home', $data);
		}
	}
	public function edit($para1)
	{
		if(isAdmin())
		{
			$data['row']= $this->CommonModel->fetch_a_row('ca_id',$para1,'notification');
            $data['content']  ="notification/Edit";
            $this->load->view('layout_home',$data);
		}
	}

	public function save()
	{
		if(isAdmin())
		{
			$input_data = $this->input->post();
            $input_data = $this->security->xss_clean($input_data);
            $customer_id=$input_data['c_id'];
foreach ($customer_id as $key => $customer) {
						$date=date('Y-m-d',strtotime($input_data['date']));
           $duplicate_data=$this->db->where('c_id', $customer)->where('date', $date)->get('notification')->result_array();
            if(empty($duplicate_data))
            {
             
        	$insert_data['c_id'] = $customer;
        	$insert_data['e_id'] = $input_data['e_id'];
        	$insert_data['date'] = $date;
        	$insert_data['assign_date'] = date('Y-m-d H:i:s');
        	
            $this->db->insert('notification',$insert_data);
          }
          }
            echo 'Success';
		}
	}

	public function Edit_data()
	{
	    if(isAdmin())
	    {  
	        	$input_data = $this->input->post();
	            $input_data = $this->security->xss_clean($input_data);
	            $edit_data['c_id'] = $input_data['c_id'];
	            $edit_data['e_id'] = $input_data['e_id'];
	        	
	            $this->db->where('ca_id',$input_data['ca_id']);
	            $this->db->update('notification',$edit_data);
	            echo 'Success';
	    }      
	}
	public function status_change()
	{
	    if(isAdmin())
	    {  
	        	$input_data = $this->input->post();
	            $input_data = $this->security->xss_clean($input_data);
	            $edit_data['status'] = $input_data['new_status'];
	        	
	            $this->db->where('ca_id',$input_data['id']);
	            $this->db->update('notification',$edit_data);
	            echo 'Success';
	    }      
	}
	public function Delete()
    {
        if(isAdmin())
        {
        	$input_data = $this->input->post();
        	$this->db->where('ca_id', $input_data['id']);
			$this->db->delete('notification');
             // / ---------------------------Insert Audit trail--------------------
            $audit_trail_table='audit_trail';
	        $audit_trail_array=array(
	                                    'user_name'=>$this->session->userdata('admin_name'),
	                                    'action'=>'Action -> "Delete Call assign"',
	                                    'action_time'=>date('Y-m-d H:i:s')
	                                );
        	$this->CommonModel->insert($audit_trail_table,$audit_trail_array);
        }
    }
public function export()
	{
		if(isAdmin())
		{ 
			$customer_array=$this->db->select('ca.ca_id,ca.c_id,ca.date,ca.assign_date, c.c_name, c.c_mobile, c.c_address,  e.employee_code, e.e_name')->from('notification as ca')->join('customer as c', 'ca.c_id = c.c_id', 'LEFT')->join('employee as e', 'ca.e_id = e.e_id', 'LEFT')->order_by('ca_id','desc')->get()->result_array();
			header("Content-type: application/csv");
		    header("Content-Disposition: attachment; filename=\"Calling-data-".date('d-m-Y').".csv\"");
		    header("Pragma: no-cache");
		    header("Expires: 0");

		     $handle = fopen('php://output', 'w');
			$excel_heding=array();
			array_push($excel_heding, 'SL', 'Customer','Mobile Number', 'Employee', 'Calling Date', 'Location', 'Duration', 'Status', 'Callers Feedback');
			fputcsv($handle, $excel_heding);
			foreach ($customer_array as $key => $customer_data) {
			$export_req = array();
			if ($customer_data['status']=='1') {
			$status='Active';
			}
			else
			{
			$status='Inactive';
			}
			array_push($export_req, $key+1, $customer_data['c_name'], $customer_data['c_mobile'], $customer_data['employee_code'], $customer_data['call_time'], $customer_data['location'], $customer_data['duration'], $customer_data['status'], $customer_data['note']);

			//print_r($call_det);die;
			fputcsv($handle, $export_req);
			} 
			 fclose($handle);
		     exit;
		
		}
	}


	public function import(){

        $data = array();

        $memData = array();

                $insertCount = $updateCount = $rowCount = $notAddCount = 0;

                if(is_uploaded_file($_FILES['import_data']['tmp_name'])){

                    $this->load->library('CSVReader');

                    $csvData = $this->csvreader->parse_csv($_FILES['import_data']['tmp_name']);

                    if(!empty($csvData)){

                        foreach($csvData as $row){ 
                        	$rowCount++;
                        	$customer_det=$this->db->where('c_mobile', $row['Customer Mobile'])->get('customer')->result_array();
                        	$employee_det=$this->db->where('employee_code', $row['Employee'])->get('employee')->result_array();
							$insert_data['c_id'] = $customer_det['0']['c_id'];
							$insert_data['e_id'] = $employee_det['0']['e_id'];
							$insert_data['date'] = date('Y-m-d',strtotime($row['Date']));
							$insert_data['assign_date'] = date('Y-m-d H:i:s');
							
							$this->db->insert('notification',$insert_data);	



                          $insertCount++;  

                        }
                        $notAddCount = ($rowCount - ($insertCount + $updateCount));
                    }
                }

    }

}