<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Liquor extends CI_Controller {

	function __construct() 
	{
        error_reporting(0);
        parent::__construct();
        $this->load->model('CommonModel');
        $this->load->helper('Security');
        $this->load->library('form_validation');

       
    }

	public function index()
	{ 
		if(isAdmin())
		{ 
			$data['recordSet']=$this->db->get('liquor')->result_array();
			$data['content'] = 'Liquor/Listing';
			$this->load->view('layout_home', $data);
		}
	}

	public function add()
	{
		if(isAdmin())
		{
			$data['recordSet']=$this->db->get('liquor_category')->result_array();
			$data['content'] = 'Liquor/Add';
			$this->load->view('layout_home', $data);
		}
	}
	public function edit($para1)
	{
		if(isAdmin())
		{
			$data['row']= $this->CommonModel->fetch_a_row('l_id',$para1,'liquor');
			$data['recordSet']=$this->db->get('liquor_category')->result_array();
            $data['content']  ="Liquor/Edit";
            $this->load->view('layout_home',$data);
		}
	}

	public function save()
	{
		if(isAdmin())
		{
			$input_data = $this->input->post();
            $input_data = $this->security->xss_clean($input_data);

            
        	$insert_data['product_code'] = $input_data['product_code'];
        	$insert_data['lc_id'] = $input_data['lc_id'];
        	$insert_data['name'] = $input_data['name'];
        	$insert_data['unit'] = $input_data['unit'];
        	$insert_data['size'] = $input_data['size'];
        	$insert_data['mrp'] = $input_data['mrp'];
        	$insert_data['purchase_price'] = $input_data['purchase_price'];
        	$insert_data['sell_price'] = $input_data['sell_price'];
        	$insert_data['stock'] = $input_data['stock'];
        	$insert_data['total_quantity'] = $input_data['total_quantity'];
        	$insert_data['hotel'] = $this->session->userdata('hotel_name');
        	
            $this->db->insert('liquor',$insert_data);
            echo 'Success';
		}
	}

	public function Edit_data()
	{
	    if(isAdmin())
	    {  
	        	$input_data = $this->input->post();
	            $input_data = $this->security->xss_clean($input_data);
	            $insert_data['product_code'] = $input_data['product_code'];
	        	$insert_data['lc_id'] = $input_data['lc_id'];
	        	$insert_data['name'] = $input_data['name'];
	        	$insert_data['unit'] = $input_data['unit'];
	        	$insert_data['size'] = $input_data['size'];
	        	$insert_data['mrp'] = $input_data['mrp'];
	        	$insert_data['purchase_price'] = $input_data['purchase_price'];
	        	$insert_data['sell_price'] = $input_data['sell_price'];
	        	$insert_data['stock'] = $input_data['stock'];
	        	$insert_data['total_quantity'] = $input_data['total_quantity'];
	        	
	            $this->db->where('l_id',$input_data['l_id']);
	            $this->db->update('liquor',$insert_data);
	            echo 'Success';
	    }      
	}
	public function status_change()
	{
	    if(isAdmin())
	    {  
	        	$input_data = $this->input->post();
	            $input_data = $this->security->xss_clean($input_data);
	            $edit_data['cat_status'] = $input_data['new_status'];
	        	
	            $this->db->where('rc_id',$input_data['id']);
	            $this->db->update('room_category',$edit_data);
	            echo 'success';
	    }      
	}
	public function Delete()
    {
        if(isAdmin())
        {
        	$input_data = $this->input->post();
        	$this->db->where('l_id', $input_data['id']);
			$this->db->delete('liquor');
             // / ---------------------------Insert Audit trail--------------------
            $audit_trail_table='audit_trail';
	        $audit_trail_array=array(
	                                    'user_name'=>$this->session->userdata('admin_name'),
	                                    'action'=>'Action -> "Delete Food"',
	                                    'action_time'=>date('Y-m-d H:i:s')
	                                );
        	$this->CommonModel->insert($audit_trail_table,$audit_trail_array);
        }
    }

    public function export()
	{
		if(isAdmin())
		{ 
			$project_array=$this->db->get('room_category')->result_array();
			header("Content-type: application/csv");
		    header("Content-Disposition: attachment; filename=\"Food-".date('d-m-Y').".csv\"");
		    header("Pragma: no-cache");
		    header("Expires: 0");

		     $handle = fopen('php://output', 'w');
			$excel_heding=array();
			array_push($excel_heding, 'SL', 'Food Name',  'Status');
			fputcsv($handle, $excel_heding);
			foreach ($project_array as $key => $project_data) {
			$export_req = array();
			if ($project_data['cat_status']=='1') {
			$status='Active';
			}
			else
			{
			$status='Inactive';
			}
			array_push($export_req, $key+1, $project_data['rc_name'], $status);

			//print_r($call_det);die;
			fputcsv($handle, $export_req);
			} 
			 fclose($handle);
		     exit;
		
		}
	}
	public function import(){

        $data = array();

        $memData = array();

                $insertCount = $updateCount = $rowCount = $notAddCount = 0;

                if(is_uploaded_file($_FILES['import_data']['tmp_name'])){

                    $this->load->library('CSVReader');

                    $csvData = $this->csvreader->parse_csv($_FILES['import_data']['tmp_name']);

                    if(!empty($csvData)){

                        foreach($csvData as $row){ 
                        	$rowCount++;
                        	
							$insert_data['Food_code'] = $row['Food Code'];
							$insert_data['e_name'] = $row['Name'];
							$insert_data['e_email'] = $row['Email ID'];
							$insert_data['e_mobile'] = $row['Mobile Number'];
							$insert_data['e_address'] = $row['Address'];
							$insert_data['e_password'] = $row['Password'];
							$insert_data['e_status'] = '1';
							$insert_data['join_date'] = date('Y-m-d H:i:s');
							
							$this->db->insert('Food',$insert_data);						
							
                          $insertCount++;  

                        }
                        $notAddCount = ($rowCount - ($insertCount + $updateCount));
                    }
                }

    }
    //////////////////////////////////////////Billing /////////////////////////////////////////////////////////

    public function billing()
	{ 
		if(isAdmin())
		{ 
			$data['recordSet']=$this->db->where('prd_type','Liquor')->order_by('billing_id','desc')->get('billing')->result_array();
			$data['content'] = 'Liquor/billing';
			$this->load->view('layout_home', $data);
		}
	}
	public function new_billing()
	{
		if(isAdmin())
		{
			$data['content'] = 'Liquor/generate_billing';
			$this->load->view('layout_home', $data);
		}
	}
	public function getData()
	{
		if(isAdmin())
		{
			$input_data = $this->input->post();
            $input_data = $this->security->xss_clean($input_data);
			$search = $input_data['search'];

		    // $query = "SELECT * FROM inventory WHERE item_name like'%".$search."%'";
		    // $result = mysqli_query($con,$query);
		    $result=$this->db->like('name', $search)->get('liquor')->result_array();
		    //echo $this->db->get_data();
		    	foreach ($result as $row) {
		        $response[] = array("label"=>$row['name'].'-'.$row['size'],"item_desc"=>'',"mrp"=>$row['mrp'],"item_code"=>$row['product_code'],"sell_price"=>$row['sell_price'],"inv_id"=>$row['l_id']);
		    	}

		    echo json_encode($response);
		}
	}
	public function barcodescan()
	{
		if(isAdmin())
		{
			$input_data = $this->input->post();
            $input_data = $this->security->xss_clean($input_data);
			$search = $input_data['search'];
			$index = $input_data['index'];

		    // $query = "SELECT * FROM inventory WHERE name like'%".$search."%'";
		    // $result = mysqli_query($con,$query);
		    $result=$this->db->where('product_code', $search)->get('liquor')->result_array();
		    
		    	foreach ($result as $row) {
		    	$cart_product_data=$this->session->userdata('cart_products');
		    	
		    	
		    	if (!in_array($row['product_code'], $cart_product_data)) {
		    		$cart_product=array();
			    	$cart_product=$this->session->userdata('cart_products');
			    	$cart_product[]=$row['product_code'];
					$this->session->set_userdata('cart_products',$cart_product);
			        $response[] = array("label"=>$row['name'].'-'.$row['size'],"item_desc"=>'',"mrp"=>$row['mrp'],"item_code"=>$row['product_code'],"sell_price"=>$row['sell_price'],"inv_id"=>$row['l_id'],"index"=>$index,"duplicate"=>'NO');
		    		}
		    	else
		    	{
		    		$response[] = array("label"=>$row['name'].'-'.$row['size'],"item_desc"=>'',"mrp"=>$row['mrp'],"item_code"=>$row['product_code'],"sell_price"=>$row['sell_price'],"inv_id"=>$row['l_id'],"index"=>$index,"duplicate"=>'Yes');
		    	}
		    	
		    }

		    echo json_encode($response);
		}
	}
	public function billing_save()
	{
		if(isAdmin())
		{
			$input_data = $this->input->post();
            $input_data = $this->security->xss_clean($input_data);
            $state_code = substr($input_data['gst'], 0, 2);
            
        	$insert_data['bill_no'] = $input_data['bill_no'];
        	$insert_data['cus_name'] = $input_data['cus_name'];
        	$insert_data['cus_phone'] = $input_data['cus_phone'];
        	$insert_data['cus_email'] = $input_data['cus_email'];
        	$insert_data['cus_address'] = $input_data['cus_address'];
        	$insert_data['delivery_mode'] = $input_data['delivery_mode'];
        	$insert_data['supply_reff'] = $input_data['supply_reff'];
        	$insert_data['oth_reff'] = $input_data['oth_reff'];
        	$insert_data['tax_type'] = $input_data['tax_type'];
        	$insert_data['gst'] = $input_data['gst'];
        	$insert_data['state'] = $input_data['state'];
        	$insert_data['city'] = $input_data['city'];
        	$insert_data['pin'] = $input_data['pin'];
        	$insert_data['dispath_documence'] = $input_data['dispath_documence'];
        	$insert_data['document_through'] = $input_data['document_through'];
        	$insert_data['delivery_note'] = $input_data['delivery_note'];
        	$insert_data['state_code'] = $state_code;
        	$insert_data['prd_type'] = 'Liquor';
            $this->db->insert('billing',$insert_data);
            $last_id=$this->db->insert_id();
            foreach ($input_data['itemName'] as $key => $rate_data) {
            	$insert_bill_data['billing_id'] = $last_id;
	        	$insert_bill_data['item_name'] = $input_data['itemName'][$key];
	        	$insert_bill_data['sl_no'] = $input_data['slno'][$key];
	        	$insert_bill_data['mrp'] = $input_data['price'][$key];
	        	$insert_bill_data['price'] = $input_data['price'][$key];
	        	$insert_bill_data['quantity'] = $input_data['qty'][$key];
	        	$insert_bill_data['description'] = '';
	            $this->db->insert('billing_data',$insert_bill_data);
            $q=$input_data['qty'][$key];
            }
		}
	}

}