<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Laundry extends CI_Controller {

	function __construct() 
	{
        error_reporting(0);
        parent::__construct();
        $this->load->model('CommonModel');
        $this->load->helper('Security');
        $this->load->library('form_validation');

       
    }

	public function index()
	{ 
		if(isAdmin())
		{ 
			$data['recordSet']=$this->db->get('laundry')->result_array();
			$data['rooms']=$this->db->get('rooms')->result_array();
			$data['content'] = 'Laundry/Listing';
			$this->load->view('layout_home', $data);
		}
	}


	public function save()
	{
		if(isAdmin())
		{
			$input_data = $this->input->post();
            $input_data = $this->security->xss_clean($input_data);
        	$insert_data['r_id'] = $input_data['r_id'];
        	$insert_data['room_number'] = $input_data['room_number'];
        	$insert_data['name'] = $input_data['name'];
        	$insert_data['number_of_cloths'] = $input_data['number_of_cloths'];
        	$insert_data['status'] = $input_data['status'];
        	
            $this->db->insert('laundry',$insert_data);
            echo 'Success';
		}
	}

	public function Edit_status()
	{
	    if(isAdmin())
	    {  
	        	$input_data = $this->input->post();
	            $input_data = $this->security->xss_clean($input_data);
	            $edit_data['status'] = $input_data['status'];
	        	
	            $this->db->where('ld_id',$input_data['ld_id']);
	            $this->db->update('laundry',$edit_data);
	            echo 'Success';
	    }      
	}
	public function details()
	{
		if(isAdmin())
		{
			$input_data = $this->input->post();
			$data = $this->db->where('ld_id', $input_data['ld_id'])->get('laundry')->result_array();
			?>
			<div class="form-group">
              <div class="col-sm-12">
                  <label>Status</label>
                  <select class="form-control" name="status" id="status" required>
                    <option value="Collected" <?php if($data[0]['status']=='Collected'){ echo 'selected'; } ?>>Collected</option>
                    <option value="At Washing Center" <?php if($data[0]['status']=='At Washing Center'){ echo 'selected'; } ?>>At Washing Center</option>
                    <option value="Returned" <?php if($data[0]['status']=='Returned'){ echo 'selected'; } ?>>Returned</option>
                  </select>
                  <input type="hidden" name="ld_id" value="<?php echo $data[0]['ld_id']; ?>">
              </div>
          </div>
			<?php
		}
	}
	public function getroomno()
	{
		if(isAdmin())
		{
			$input_data = $this->input->post();
			$data = $this->db->where('r_id', $input_data['type1'])->get('room_numbers')->result_array();
			?>
                <label for="InputText1">Room Number </label>
                <select class="form-control" name="room_number" id="room_number" required>
                  <option value="">--Select Room Number--</option>
                  <?php foreach ($data as $key_room) { ?>
                    <option value="<?php echo $key_room['room_number']; ?>"><?php echo $key_room['room_number']; ?></option>
                  <?php } ?>
                </select>
			<?php
		}
	}
	public function status_change()
	{
	    if(isAdmin())
	    {  
	        	$input_data = $this->input->post();
	            $input_data = $this->security->xss_clean($input_data);
	            $edit_data['cat_status'] = $input_data['new_status'];
	        	
	            $this->db->where('rc_id',$input_data['id']);
	            $this->db->update('room_category',$edit_data);
	            echo 'success';
	    }      
	}
	public function Delete()
    {
        if(isAdmin())
        {
        	$input_data = $this->input->post();
        	$this->db->where('rc_id', $input_data['id']);
			$this->db->delete('room_category');
             // / ---------------------------Insert Audit trail--------------------
            $audit_trail_table='audit_trail';
	        $audit_trail_array=array(
	                                    'user_name'=>$this->session->userdata('admin_name'),
	                                    'action'=>'Action -> "Delete Rooms"',
	                                    'action_time'=>date('Y-m-d H:i:s')
	                                );
        	$this->CommonModel->insert($audit_trail_table,$audit_trail_array);
        }
    }

    public function export()
	{
		if(isAdmin())
		{ 
			$project_array=$this->db->get('room_category')->result_array();
			header("Content-type: application/csv");
		    header("Content-Disposition: attachment; filename=\"rooms-".date('d-m-Y').".csv\"");
		    header("Pragma: no-cache");
		    header("Expires: 0");

		     $handle = fopen('php://output', 'w');
			$excel_heding=array();
			array_push($excel_heding, 'SL', 'Rooms Name',  'Status');
			fputcsv($handle, $excel_heding);
			foreach ($project_array as $key => $project_data) {
			$export_req = array();
			if ($project_data['cat_status']=='1') {
			$status='Active';
			}
			else
			{
			$status='Inactive';
			}
			array_push($export_req, $key+1, $project_data['rc_name'], $status);

			//print_r($call_det);die;
			fputcsv($handle, $export_req);
			} 
			 fclose($handle);
		     exit;
		
		}
	}
	public function import(){

        $data = array();

        $memData = array();

                $insertCount = $updateCount = $rowCount = $notAddCount = 0;

                if(is_uploaded_file($_FILES['import_data']['tmp_name'])){

                    $this->load->library('CSVReader');

                    $csvData = $this->csvreader->parse_csv($_FILES['import_data']['tmp_name']);

                    if(!empty($csvData)){

                        foreach($csvData as $row){ 
                        	$rowCount++;
                        	
							$insert_data['Rooms_code'] = $row['Rooms Code'];
							$insert_data['e_name'] = $row['Name'];
							$insert_data['e_email'] = $row['Email ID'];
							$insert_data['e_mobile'] = $row['Mobile Number'];
							$insert_data['e_address'] = $row['Address'];
							$insert_data['e_password'] = $row['Password'];
							$insert_data['e_status'] = '1';
							$insert_data['join_date'] = date('Y-m-d H:i:s');
							
							$this->db->insert('Rooms',$insert_data);						
							
                          $insertCount++;  

                        }
                        $notAddCount = ($rowCount - ($insertCount + $updateCount));
                    }
                }

    }

}