<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Inventory extends CI_Controller {

	function __construct() 
	{
        error_reporting(0);
        parent::__construct();
        $this->load->model('CommonModel');
        $this->load->helper('Security');
        $this->load->library('form_validation');

       
    }

	public function index()
	{ 
		if(isAdmin())
		{ 
			$data['recordSet']=$this->db->get('inventory')->result_array();
			$data['content'] = 'Inventory/Listing';
			$this->load->view('layout_home', $data);
		}
	}

	public function add()
	{
		if(isAdmin())
		{
			$data['content'] = 'Inventory/Add';
			$this->load->view('layout_home', $data);
		}
	}
	public function edit($para1)
	{
		if(isAdmin())
		{
			$data['row']= $this->CommonModel->fetch_a_row('inv_id',$para1,'inventory');
            $data['content']  ="Inventory/Edit";
            $this->load->view('layout_home',$data);
		}
	}

	public function save()
	{
		if(isAdmin())
		{
			$input_data = $this->input->post();
            $input_data = $this->security->xss_clean($input_data);
            	
            	$insert_data['item_name'] = $input_data['item_name'];
            	$insert_data['item_desc'] = $input_data['item_desc'];
            	$insert_data['price'] = $input_data['price'];
            	$insert_data['opening_stock'] = $input_data['opening_stock'];
            	$insert_data['item_status'] = '1';
            	$insert_data['available_stock'] = $input_data['opening_stock'];
	            $this->db->insert('inventory',$insert_data);
	            
            echo 'Success';
        }
		
	}

	public function Edit_data()
	{
	    if(isAdmin())
	    {  
        	$input_data = $this->input->post();
            $input_data = $this->security->xss_clean($input_data);

            
            	$insert_data['item_name'] = $input_data['item_name'];
            	$insert_data['item_desc'] = $input_data['item_desc'];
            	$insert_data['price'] = $input_data['price'];
            	$insert_data['opening_stock'] = $input_data['opening_stock'];
            	$insert_data['available_stock'] = $input_data['opening_stock'];
            	$this->db->where('inv_id',$input_data['inv_id']);
	            $this->db->update('inventory',$insert_data);
	            echo 'success';
	    }      
	}
	public function status_change()
	{
	    if(isAdmin())
	    {  
	        	$input_data = $this->input->post();
	            $input_data = $this->security->xss_clean($input_data);
	        	$edit_data['item_status	'] = $input_data['new_status'];
	        	
	            $this->db->where('inv_id',$input_data['id']);
	            $this->db->update('inventory',$edit_data);
	            echo 'success';
	    }      
	}

	public function Delete()
    {
        if(isAdmin())
        {
        	$input_data = $this->input->post();
        	$this->db->where('inv_id', $input_data['id']);
			$this->db->delete('inventory');
        }
    }

    public function export()
	{
		if(isAdmin())
		{ 
			$project_array=$this->db->select('d.prd_id,d.vt_id,d.project_id,d.d_code,d.d_name,d.working_project,d.d_pass,d.date,vt.vehicle_type, p.project_code, p.project_name')->from('product as d')->join('project as p', 'd.project_id = p.project_id', 'LEFT')->join('vehicle_type as vt', 'd.vt_id = vt.vt_id', 'LEFT')->order_by('prd_id','desc')->get()->result_array();
			header("Content-type: application/csv");
		    header("Content-Disposition: attachment; filename=\"product-".date('d-m-Y').".csv\"");
		    header("Pragma: no-cache");
		    header("Expires: 0");

		     $handle = fopen('php://output', 'w');
			$excel_heding=array();
			array_push($excel_heding, 'SL', 'SAP ID', 'Product Name', 'Working Project', 'Product Paassword', 'Vehicle Type', 'Status','Date');
			fputcsv($handle, $excel_heding);
			foreach ($project_array as $key => $project_data) {
			$export_req = array();
			if ($project_data['d_status']=='1') {
			$status='Active';
			}
			else
			{
			$status='Inactive';
			}
			$registered_data=date('Y-m-d', strtotime($project_data['date']));
			array_push($export_req, $key+1, $project_data['d_code'], $project_data['d_name'], $project_data['project_code'], $project_data['d_pass'], $project_data['vehicle_type'], $status, $registered_data);

			//print_r($call_det);die;
			fputcsv($handle, $export_req);
			} 
			 fclose($handle);
		     exit;
		
		}
	}

	public function import(){

        $data = array();

        $memData = array();

                $insertCount = $updateCount = $rowCount = $notAddCount = 0;

                if(is_uploaded_file($_FILES['import_data']['tmp_name'])){

                    $this->load->library('CSVReader');

                    $csvData = $this->csvreader->parse_csv($_FILES['import_data']['tmp_name']);

                    if(!empty($csvData)){

                        foreach($csvData as $row){ 
                        	$rowCount++;
                        	$project_det=$this->db->where('project_code', $row[0]['Project Code'])->get('project')->result_array();
                        	$vehicle_type_det=$this->db->where('vehicle_type', $row[0]['Vehicle Type'])->get('vehicle_type')->result_array();
                        	$duplicate_data=$this->db->where('d_code', $row[0]['SAP ID'])->or_where('d_code', $row[0]['Product Password'])->get('product')->result_array();
				            if(empty($duplicate_data))
				            {
							$insert_data['vt_id'] = $vehicle_type_det['0']['vt_id'];
							$insert_data['project_id'] = $project_det['0']['project_id'];
							$insert_data['d_code'] = $row[0]['SAP ID'];
							$insert_data['d_name'] = $row[0]['Product Name'];
							$insert_data['working_project'] = $row[0]['Project Code'];
							$insert_data['d_pass'] = $row[0]['Product Password'];
							$insert_data['vehicle_type'] = $row[0]['Vehicle Type'];
							$insert_data['d_status'] = 1;
							$insert_data['device_id'] = '';
							
							$this->db->insert('product',$insert_data);
							}

	
                          $insertCount++;  

                        }
                        $notAddCount = ($rowCount - ($insertCount + $updateCount));
                    }
                }

    }

}