<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class HouseKeeping extends CI_Controller {

	function __construct() 
	{
        error_reporting(0);
        parent::__construct();
        $this->load->model('CommonModel');
        $this->load->helper('Security');
        $this->load->library('form_validation');

       
    }

	public function index()
	{ 
		if(isAdmin())
		{ 
			$data['recordSet']=$this->db->get('house_keeping')->result_array();
			$data['rooms']=$this->db->get('rooms')->result_array();
			$data['content'] = 'HouseKeeping/Listing';
			$this->load->view('layout_home', $data);
		}
	}

	public function checkout()
	{ 
		if(isAdmin())
		{ 
			$data['recordSet']=$this->db->select('rn.room_number,rn.rn_id,,rn.room_status,r.r_type, r.r_id')->from('room_numbers as rn')->join('rooms as r', 'rn.r_id = r.r_id', 'LEFT')->where('rn.room_status','Check out')->or_where('rn.room_status','Shift')->get()->result_array();
			$data['rooms']=$this->db->get('rooms')->result_array();
			$data['content'] = 'HouseKeeping/Listing_checkout';
			$this->load->view('layout_home', $data);
		}
	}


	public function save()
	{
		if(isAdmin())
		{
			$input_data = $this->input->post();
            $input_data = $this->security->xss_clean($input_data);
            $data_chk=$this->db->where('date',$input_data['date'])->where('r_id',$input_data['r_id'])->where('room_number',$input_data['room_number'])->get('house_keeping')->result_array();
            // print_r($this->db->last_query()); die;
           if($data_chk){
           	echo 'failed';
           } else{
        	$insert_data['r_id'] = $input_data['r_id'];
        	$insert_data['room_number'] = $input_data['room_number'];
        	$insert_data['room_cleaning'] = $input_data['room_cleaning'];
        	$insert_data['pillow_c_change'] = $input_data['pillow_c_change'];
        	$insert_data['bed_s_change'] = $input_data['bed_s_change'];
        	$insert_data['blanket_c_change'] = $input_data['blanket_c_change'];
        	$insert_data['toilet_cleaning'] = $input_data['toilet_cleaning'];
        	$insert_data['toiletries_change'] = $input_data['toiletries_change'];
        	$insert_data['electronics_check'] = $input_data['electronics_check'];
        	$insert_data['water_check'] = $input_data['water_check'];
        	$insert_data['date'] = $input_data['date'];
        	
            $this->db->insert('house_keeping',$insert_data);
            
            $edit_data['room_status'] = 'Available';
        	
            $this->db->where('room_number',$input_data['room_number']);
            $this->db->update('room_numbers',$edit_data);
            echo 'Success';
        	}
		}
	}

	public function Edit_data()
	{
	    if(isAdmin())
	    {  
	        	$input_data = $this->input->post();
	            $input_data = $this->security->xss_clean($input_data);
	            $edit_data['rc_name'] = $input_data['rc_name'];
	        	
	            $this->db->where('rc_id',$input_data['rc_id']);
	            $this->db->update('room_category',$edit_data);
	            echo 'Success';
	    }      
	}
	public function details()
	{
		if(isAdmin())
		{
			$input_data = $this->input->post();
			$data = $this->db->where('hk_id', $input_data['hk_id'])->get('house_keeping')->result_array();
			$rno=explode(',', $data[0]['room_numbers']);
			?>
				<table class="table" border="1">
				  <tr>
				    <th>Task</th>
				    <th>Completed (YES/NO)</th>
				  </tr>
				  <tr>
				    <td>Room Cleaning</td>
				    <td><?php echo $data[0]['room_cleaning']; ?></td>
				  </tr>
				  <tr>
				    <td>Pillow Cover Change</td>
				    <td><?php echo $data[0]['pillow_c_change']; ?></td>
				  </tr>
				  <tr>
				    <td>Bed sheet Change</td>
				    <td><?php echo $data[0]['bed_s_change']; ?></td>
				  </tr>
				  <tr>
				    <td>Blanket Cover Change</td>
				    <td><?php echo $data[0]['blanket_c_change']; ?></td>
				  </tr>
				  <tr>
				    <td>Toilet Cleaning</td>
				    <td><?php echo $data[0]['toilet_cleaning']; ?></td>
				  </tr>
				  <tr>
				    <td>Toiletries Change</td>
				    <td><?php echo $data[0]['toiletries_change']; ?></td>
				  </tr>
				  <tr>
				    <td>Electronics Items Check</td>
				    <td><?php echo $data[0]['electronics_check']; ?></td>
				  </tr>
				  <tr>
				    <td>Drinking Water kept Check</td>
				    <td><?php echo $data[0]['water_check']; ?></td>
				  </tr>
				</table>
			<?php
		}
	}
	public function getroomno()
	{
		if(isAdmin())
		{
			$input_data = $this->input->post();
			$data = $this->db->where('r_id', $input_data['type1'])->get('room_numbers')->result_array();
			?>
                <label for="InputText1">Room Number </label>
                <select class="form-control" name="room_number" id="room_number" required>
                  <option value="">--Select Room Number--</option>
                  <?php foreach ($data as $key_room) { ?>
                    <option value="<?php echo $key_room['room_number']; ?>"><?php echo $key_room['room_number']; ?></option>
                  <?php } ?>
                </select>
			<?php
		}
	}
	public function status_change()
	{
	    if(isAdmin())
	    {  
	        	$input_data = $this->input->post();
	            $input_data = $this->security->xss_clean($input_data);
	            $edit_data['cat_status'] = $input_data['new_status'];
	        	
	            $this->db->where('rc_id',$input_data['id']);
	            $this->db->update('room_category',$edit_data);
	            echo 'success';
	    }      
	}
	public function Delete()
    {
        if(isAdmin())
        {
        	$input_data = $this->input->post();
        	$this->db->where('rc_id', $input_data['id']);
			$this->db->delete('room_category');
             // / ---------------------------Insert Audit trail--------------------
            $audit_trail_table='audit_trail';
	        $audit_trail_array=array(
	                                    'user_name'=>$this->session->userdata('admin_name'),
	                                    'action'=>'Action -> "Delete Rooms"',
	                                    'action_time'=>date('Y-m-d H:i:s')
	                                );
        	$this->CommonModel->insert($audit_trail_table,$audit_trail_array);
        }
    }

    public function export()
	{
		if(isAdmin())
		{ 
			$project_array=$this->db->get('room_category')->result_array();
			header("Content-type: application/csv");
		    header("Content-Disposition: attachment; filename=\"rooms-".date('d-m-Y').".csv\"");
		    header("Pragma: no-cache");
		    header("Expires: 0");

		     $handle = fopen('php://output', 'w');
			$excel_heding=array();
			array_push($excel_heding, 'SL', 'Rooms Name',  'Status');
			fputcsv($handle, $excel_heding);
			foreach ($project_array as $key => $project_data) {
			$export_req = array();
			if ($project_data['cat_status']=='1') {
			$status='Active';
			}
			else
			{
			$status='Inactive';
			}
			array_push($export_req, $key+1, $project_data['rc_name'], $status);

			//print_r($call_det);die;
			fputcsv($handle, $export_req);
			} 
			 fclose($handle);
		     exit;
		
		}
	}
	public function import(){

        $data = array();

        $memData = array();

                $insertCount = $updateCount = $rowCount = $notAddCount = 0;

                if(is_uploaded_file($_FILES['import_data']['tmp_name'])){

                    $this->load->library('CSVReader');

                    $csvData = $this->csvreader->parse_csv($_FILES['import_data']['tmp_name']);

                    if(!empty($csvData)){

                        foreach($csvData as $row){ 
                        	$rowCount++;
                        	
							$insert_data['Rooms_code'] = $row['Rooms Code'];
							$insert_data['e_name'] = $row['Name'];
							$insert_data['e_email'] = $row['Email ID'];
							$insert_data['e_mobile'] = $row['Mobile Number'];
							$insert_data['e_address'] = $row['Address'];
							$insert_data['e_password'] = $row['Password'];
							$insert_data['e_status'] = '1';
							$insert_data['join_date'] = date('Y-m-d H:i:s');
							
							$this->db->insert('Rooms',$insert_data);						
							
                          $insertCount++;  

                        }
                        $notAddCount = ($rowCount - ($insertCount + $updateCount));
                    }
                }

    }

}