<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Hotel_booking extends CI_Controller {

	function __construct() 
	{
        error_reporting(0);
        parent::__construct();
        $this->load->model('CommonModel');
        $this->load->helper('Security');
        $this->load->library('form_validation');

       
    }

	public function index()
	{ 
		if(isAdmin())
		{ 
			$data['recordSet']=$this->db->select('r.r_id,r.booking_code,r.r_name,r.r_phone, r.r_visit_purpose, r.num_guest,  r.num_rooms,  r.rooms_category,  r.check_in, r.check_out,  r.documents, d.d_name, v.vp_name, rc.rc_name, d.d_name, p.pm_name')->from('reservation as r')->join('visit_purpose as v', 'r.r_visit_purpose = v.vp_id', 'LEFT')->join('room_category as rc', 'r.rooms_category = rc.rc_id', 'LEFT')->join('payment_mode as p', 'r.payment_mode = p.pm_id', 'LEFT')->join('documents as d', 'r.documents_type = d.d_id', 'LEFT')->where('r.status','1')->order_by('r.r_id','desc')->get()->result_array();
			//echo $this->db->last_query();die;
			$data['content'] = 'Hotel_booking/Listing';
			$this->load->view('layout_home', $data);
		}
	}

	public function file_name($file_name)
	{ 
		if(isAdmin())
		{ 
			$data['recordSet']=$this->db->where('file_name',$file_name)->order_by('c_id','desc')->get('customer')->result_array();
			$data['content'] = 'Customer/Listing';
			$this->load->view('layout_home', $data);
		}
	}

	public function add()
	{
		if(isAdmin())
		{
			$data['category']=$this->db->where('cat_status', '1')->get('category')->result_array();
			$data['content'] = 'Customer/Add';
			$this->load->view('layout_home', $data);
		}
	}
	public function edit($para1)
	{
		if(isAdmin())
		{

			$data['category']=$this->db->where('cat_status', '1')->get('category')->result_array();
			$data['row']= $this->CommonModel->fetch_a_row('c_id',$para1,'customer');
            $data['content']  ="Customer/Edit";
            $this->load->view('layout_home',$data);
		}
	}

	public function save()
	{
		if(isAdmin())
		{
			$input_data = $this->input->post();
            $input_data = $this->security->xss_clean($input_data);

        	$insert_data['c_name'] = $input_data['c_name'];
        	$insert_data['c_mobile'] = $input_data['c_mobile'];
        	$insert_data['c_email'] = $input_data['c_email'];
        	$insert_data['c_address'] = $input_data['c_address'];
        	$insert_data['file_name'] = 'Manually Added';
        	$insert_data['c_category'] = $input_data['c_category'];
        	
            $this->db->insert('customer',$insert_data);
            echo 'success';
		}
	}

	public function Edit_data()
	{
	    if(isAdmin())
	    {  
	        	$input_data = $this->input->post();
	            $input_data = $this->security->xss_clean($input_data);

	            $edit_data['c_name'] = $input_data['c_name'];
	        	$edit_data['c_mobile'] = $input_data['c_mobile'];
	        	$edit_data['c_email'] = $input_data['c_email'];
	        	$edit_data['c_address'] = $input_data['c_address'];
	        	$edit_data['c_category'] = $input_data['c_category'];
	        	
	            $this->db->where('c_id',$input_data['c_id']);
	            $this->db->update('customer',$edit_data);
	            echo 'success';
	    }      
	}
	public function details()
	{
	    if(isAdmin())
	    {  
	        	$input_data = $this->input->post();
	            $input_data = $this->security->xss_clean($input_data);
	            ?>
	            <table id="myTable" class="display table" style="width:100%">
<tbody >
<?php
$booking_deatils=$this->db->select('r.r_id,r.booking_code,r.r_name,r.r_phone, r.r_visit_purpose, r.num_guest,  r.num_rooms,  r.rooms_category,  r.check_in, r.check_out,  r.documents,  v.vp_name, rc.rc_name, d.d_name, p.pm_name')->from('reservation as r')->join('visit_purpose as v', 'r.r_visit_purpose = v.vp_id', 'LEFT')->join('room_category as rc', 'r.rooms_category = rc.rc_id', 'LEFT')->join('payment_mode as p', 'r.payment_mode = p.pm_id', 'LEFT')->join('documents as d', 'r.documents_type = d.d_id', 'LEFT')->where('r.status','1')->where('r.r_id',$input_data['booking_id'])->order_by('r.r_id','desc')->get()->result_array();
?>
<tr>
<td> Documents</td>
<td class="center"><img src="https://ohkolkata.com/hotel/uploads/documents/<?php echo $booking_deatils[0]['documents']; ?>"  height="300"></td>
</tr>
<tr>
<td> Booking Code</td>
<td class="center"><a href="#"><?php echo $booking_deatils[0]['booking_code']; ?></a></td>
</tr>
<tr>
<td>Name</td>
<td class="center"><?php echo $booking_deatils[0]['r_name']; ?></td>
</tr>
<tr>
<td>Mobile</td>
<td class="center"><?php echo $booking_deatils[0]['r_phone']; ?><br></td>
</tr>
<tr>
<td>Num Guest</td>
<td class="center"><?php echo $booking_deatils[0]['num_guest']; ?><br></td>
</tr>
<tr>
<td>Num Rooms</td>
<td class="center"><?php echo $booking_deatils[0]['num_rooms']; ?><br></td>
</tr>
<tr>
<td>Check In</td>
<td class="center"><?php echo $booking_deatils[0]['check_in']; ?><br></td>
</tr>
<tr>
<td>Check Out</td>
<td class="center"><?php echo $booking_deatils[0]['check_out']; ?><br></td>
</tr>
<tr>
<td>Visit Purpose</td>
<td class="center"><?php echo $booking_deatils[0]['vp_name']; ?><br></td>
</tr>
<tr>
<td>Room</td>
<td class="center"><?php echo $booking_deatils[0]['rc_name']; ?><br></td>
</tr>
<tr>
<td>Documents Type</td>
<td class="center"><?php echo $booking_deatils[0]['d_name']; ?><br></td>
</tr>
<tr>
<td>Payments Mode</td>
<td class="center"><?php echo $booking_deatils[0]['pm_name']; ?><br></td>
</tr>
<?php 
$others_person=$this->db->where('r_id', $booking_deatils[0]['r_id'])->get('visitor_details')->result_array();
foreach ($others_person as $key => $booking_data) {
?>
<tr>
<td>Other People</td>
<td class="center"><?php echo $booking_data['f_name'].' '.$booking_data['f_l_name']; ?>-Minor:<?php echo $booking_data['minor']; ?><br></td>
</tr>
<?php
}
?>


</tbody>
</table>
	            <?php
	    }      
	}
	public function Delete()
    {
        if(isAdmin())
        {
        	$input_data = $this->input->post();
        	$this->db->where('c_id', $input_data['id']);
			$this->db->delete('customer');
             // / ---------------------------Insert Audit trail--------------------
            $audit_trail_table='audit_trail';
	        $audit_trail_array=array(
	                                    'user_name'=>$this->session->userdata('admin_name'),
	                                    'action'=>'Action -> "Delete Customer"',
	                                    'action_time'=>date('Y-m-d H:i:s')
	                                );
        	$this->CommonModel->insert($audit_trail_table,$audit_trail_array);
        }
    }

    public function export()
	{
		if(isAdmin())
		{ 
			$project_array=$this->db->get('customer')->result_array();
			header("Content-type: application/csv");
		    header("Content-Disposition: attachment; filename=\"Customer-".date('d-m-Y').".csv\"");
		    header("Pragma: no-cache");
		    header("Expires: 0");

		     $handle = fopen('php://output', 'w');
			$excel_heding=array();
			array_push($excel_heding, 'SL', 'Name', 'Mobile','Email ID', 'Address',  'Category',  'File Name');
			fputcsv($handle, $excel_heding);
			foreach ($project_array as $key => $project_data) {
			$category_data=$this->db->where('cat_id', $project_data['c_category'])->get('category')->result_array();
			$category = $category_data[0]['cat_name'];
			$export_req = array();
			array_push($export_req, $key+1, $project_data['c_name'], $project_data['c_mobile'], $project_data['c_email'], $project_data['c_address'], $category, $project_data['file_name']);

			//print_r($call_det);die;
			fputcsv($handle, $export_req);
			} 
			 fclose($handle);
		     exit;
		
		}
	}

	public function import(){

       // $data = array();

       //  $memData = array();

       //  $insertCount = $updateCount = $rowCount = $notAddCount = 0;

       //  if(is_uploaded_file($_FILES['import_data']['tmp_name'])){
       //  	echo 'hi';

       //      $this->load->library('CSVReader');

       //      $csvData = $this->csvreader->parse_csv($_FILES['import_data']['tmp_name']);
       //      // print_r($csvData); die;
       //      if(!empty($csvData)){
       //      	echo 'welcome';
       //          foreach($csvData as $row){ 
       //          	$rowCount++;
       //          	$category_data=$this->db->where('cat_name', $row['Category'])->get('category')->result_array();
	// 				$insert_data['c_name'] = $row['Name'];
	// 				$insert_data['c_mobile'] = $row['Mobile Number'];
	// 				$insert_data['c_address'] = $row['Address'];
	// 				$insert_data['c_category'] = $category_data[0]['cat_id'];
					
	// 				$this->db->insert('customer',$insert_data);	
										
					
       //            $insertCount++;  

       //          }
       //          $notAddCount = ($rowCount - ($insertCount + $updateCount));
       //      }
       //  }





        $input_data = $this->input->post();
            $input_data = $this->security->xss_clean($input_data);
            $this->load->library('Csvimport');

             $file_data = $this->csvimport->get_array($_FILES["import_data"]["tmp_name"]); 
             $i=1;     
            
             
             foreach($file_data as $row) 
             { 
             	$category_data=$this->db->where('cat_name', $row['Category'])->get('category')->result_array();
             	if (!empty($category_data)) {
             	
             	$employee_data=$this->db->where('employee_code', $row['Employee Code'])->get('employee')->result_array();
                $insert_data['c_name'] = $row['Name'];			
				$insert_data['c_mobile'] = $row['Mobile Number'];
				$insert_data['c_email'] = $row['Email ID'];
				$insert_data['c_address'] = $row['Address'];
				$insert_data['file_name'] = $row['File Name'];
				$insert_data['c_category'] = $category_data[0]['cat_id'];
				$this->db->insert('customer',$insert_data); 
				$customer_id=$this->db->insert_id();
				if (!empty($employee_data)) {
				
				$assign_data['c_id'] = $customer_id;			
				$assign_data['e_id'] = $employee_data[0]['e_id'];
				$assign_data['date'] = date('Y-m-d',strtotime($row['Date']));
				$assign_data['assign_date'] = date('Y-m-d H:i:s');
				$assign_data['status'] = 0;
				$this->db->insert('call_assign',$assign_data);  
				}
			}


             } 
             
            






    }
}