<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Globals extends CI_Controller {

	function __construct() 
	{
        error_reporting(0);
        parent::__construct();
        $this->load->model('CommonModel');
        $this->load->helper('Security');
        $this->load->library('form_validation');
       
    }

	public function Settings()
	{
	    if(isAdmin() || isSubAdmin())
	    {  
            $data['row']= $this->CommonModel->fetch_a_row('id','1','global_settings');
            $data['content']  ="Global/settings";
            $this->load->view('layout_home',$data);
	    }      
	}

	public function SettingsSave()
	{
	    if(isAdmin() || isSubAdmin())
	    {
	        $input_data = $this->input->post();
	        $input_data = $this->security->xss_clean($input_data);
	       	$this->form_validation->set_rules('Email', 'Email', 'required|valid_email');
	       	$this->form_validation->set_rules('Email2', '2nd Email', 'valid_email');
	       	$this->form_validation->set_rules('Phone', 'Phone', 'required|numeric');
	       	$this->form_validation->set_rules('Phone2', '2nd Phone', 'numeric');
	       	//$this->form_validation->set_rules('Address', 'Address', 'required');
	       	$this->form_validation->set_rules('About_Us_Text', 'About Us Text', 'required');
	       	$this->form_validation->set_rules('Subscribe_Us_Text', 'Subscribe Us Text', 'required');
	       	$this->form_validation->set_rules('Google_Map', 'Google Map', 'required');
	       	

	        if ($this->form_validation->run() == FALSE)
	        {
	        	$data['content'] = 'Global/settings';
				$this->load->view('layout_home', $data);
	        }
	        else
	        {
	        	$edit_data['email'] = $input_data['Email'];
	        	$edit_data['email2'] = $input_data['Email2'];
	        	$edit_data['phone'] = $input_data['Phone'];
	        	$edit_data['phone2'] = $input_data['Phone2'];
	        	$edit_data['address'] = $input_data['Address'];
	        	$edit_data['about_us_text'] = $input_data['About_Us_Text'];
	        	$edit_data['subscribe_us_text'] = $input_data['Subscribe_Us_Text'];
	        	$edit_data['google_map'] = $input_data['Google_Map'];
	        	$edit_data['last_updated_date'] = Date('Y-m-d H:i:s');

	            $this->db->where('id','1');
	            $this->db->update('global_settings',$edit_data);
	            $this->session->set_flashdata('success', 'Globlal Settings changed Successfully ');
	            // ---------------------------Insert Audit trail--------------------
	            $audit_trail_table='audit_trail';
		        $audit_trail_array=array(
		                                    'user_name'=>$this->session->userdata('admin_name'),
		                                    'action'=>'Action -> "Edit Global Settings"',
		                                    'action_time'=>date('Y-m-d H:i:s')
		                                );
	        	$this->CommonModel->insert($audit_trail_table,$audit_trail_array);
	            // ----------------------------End----------------------------------
	            redirect(base_url('Globals/Settings'));
	        } 
	    }
	}   

}