<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Food extends CI_Controller {

	function __construct() 
	{
        error_reporting(0);
        parent::__construct();
        $this->load->model('CommonModel');
        $this->load->helper('Security');
        $this->load->library('form_validation');

       
    }

	public function index()
	{ 
		if(isAdmin())
		{ 
			$data['recordSet']=$this->db->where_not_in('cat_id','9')->get('food')->result_array();
			$data['content'] = 'Food/Listing';
			$this->load->view('layout_home', $data);
		}
	}
	public function beverages()
	{ 
		if(isAdmin())
		{ 
			$data['recordSet']=$this->db->where('cat_id','9')->get('food')->result_array();
			$data['content'] = 'Food/BListing';
			$this->load->view('layout_home', $data);
		}
	}

	public function add()
	{
		if(isAdmin())
		{
			$data['category']=$this->db->where('cat_status','1')->get('category')->result_array();
			$data['content'] = 'Food/Add';
			$this->load->view('layout_home', $data);
		}
	}
	public function edit($para1)
	{
		if(isAdmin())
		{
			$data['row']= $this->CommonModel->fetch_a_row('f_id',$para1,'food');
			$data['category']=$this->db->where('cat_status','1')->get('category')->result_array();
            $data['content']  ="Food/Edit";
            $this->load->view('layout_home',$data);
		}
	}

	public function save()
	{
		if(isAdmin())
		{
			$input_data = $this->input->post();
            $input_data = $this->security->xss_clean($input_data);

            
        	$insert_data['cat_id'] = $input_data['cat_id'];
        	$insert_data['f_name'] = $input_data['f_name'];
        	$insert_data['type'] = $input_data['type'];
        	$insert_data['unit'] = $input_data['unit'];
        	$insert_data['size'] = $input_data['size'];
        	$insert_data['f_price'] = $input_data['f_price'];
        	$insert_data['quantity'] = $input_data['quantity'];
        	$insert_data['hotel'] = $this->session->userdata('hotel_name');
        	$insert_data['status'] = '1';
        	
            $this->db->insert('food',$insert_data);
            echo 'Success';
		}
	}

	public function Edit_data()
	{
	    if(isAdmin())
	    {  
	        	$input_data = $this->input->post();
	            $input_data = $this->security->xss_clean($input_data);
	            $insert_data['cat_id'] = $input_data['cat_id'];
	        	$insert_data['f_name'] = $input_data['f_name'];
	        	$insert_data['type'] = $input_data['type'];
	        	$insert_data['unit'] = $input_data['unit'];
	        	$insert_data['size'] = $input_data['size'];
	        	$insert_data['f_price'] = $input_data['f_price'];
	        	$insert_data['quantity'] = $input_data['quantity'];
	        	
	            $this->db->where('f_id',$input_data['f_id']);
	            $this->db->update('food',$insert_data);
	            echo 'Success';
	    }      
	}
	public function status_change()
	{
	    if(isAdmin())
	    {  
	        	$input_data = $this->input->post();
	            $input_data = $this->security->xss_clean($input_data);
	            $edit_data['status'] = $input_data['new_status'];
	        	
	            $this->db->where('f_id',$input_data['id']);
	            $this->db->update('food',$edit_data);
	            echo 'success';
	    }      
	}
	public function Delete()
    {
        if(isAdmin())
        {
        	$input_data = $this->input->post();
        	$this->db->where('f_id', $input_data['id']);
			$this->db->delete('food');
             // / ---------------------------Insert Audit trail--------------------
            $audit_trail_table='audit_trail';
	        $audit_trail_array=array(
	                                    'user_name'=>$this->session->userdata('admin_name'),
	                                    'action'=>'Action -> "Delete Food"',
	                                    'action_time'=>date('Y-m-d H:i:s')
	                                );
        	$this->CommonModel->insert($audit_trail_table,$audit_trail_array);
        }
    }

    public function export()
	{
		if(isAdmin())
		{ 
			$project_array=$this->db->get('room_category')->result_array();
			header("Content-type: application/csv");
		    header("Content-Disposition: attachment; filename=\"Food-".date('d-m-Y').".csv\"");
		    header("Pragma: no-cache");
		    header("Expires: 0");

		     $handle = fopen('php://output', 'w');
			$excel_heding=array();
			array_push($excel_heding, 'SL', 'Food Name',  'Status');
			fputcsv($handle, $excel_heding);
			foreach ($project_array as $key => $project_data) {
			$export_req = array();
			if ($project_data['cat_status']=='1') {
			$status='Active';
			}
			else
			{
			$status='Inactive';
			}
			array_push($export_req, $key+1, $project_data['rc_name'], $status);

			//print_r($call_det);die;
			fputcsv($handle, $export_req);
			} 
			 fclose($handle);
		     exit;
		
		}
	}
	public function import(){

        $data = array();

        $memData = array();

                $insertCount = $updateCount = $rowCount = $notAddCount = 0;

                if(is_uploaded_file($_FILES['import_data']['tmp_name'])){

                    $this->load->library('CSVReader');

                    $csvData = $this->csvreader->parse_csv($_FILES['import_data']['tmp_name']);

                    if(!empty($csvData)){

                        foreach($csvData as $row){ 
                        	$rowCount++;
                        	
							$insert_data['Food_code'] = $row['Food Code'];
							$insert_data['e_name'] = $row['Name'];
							$insert_data['e_email'] = $row['Email ID'];
							$insert_data['e_mobile'] = $row['Mobile Number'];
							$insert_data['e_address'] = $row['Address'];
							$insert_data['e_password'] = $row['Password'];
							$insert_data['e_status'] = '1';
							$insert_data['join_date'] = date('Y-m-d H:i:s');
							
							$this->db->insert('Food',$insert_data);						
							
                          $insertCount++;  

                        }
                        $notAddCount = ($rowCount - ($insertCount + $updateCount));
                    }
                }

    }


    //////////////////////////////////////////Billing /////////////////////////////////////////////////////////

    public function billing()
	{ 
		if(isAdmin())
		{ 
			$data['recordSet']=$this->db->where('prd_type','Food')->order_by('billing_id','desc')->get('billing')->result_array();
			$data['content'] = 'Food/billing';
			$this->load->view('layout_home', $data);
		}
	}
	public function new_billing()
	{
		if(isAdmin())
		{
			$data['content'] = 'Food/generate_billing';
			$this->load->view('layout_home', $data);
		}
	}
	public function getData()
	{
		if(isAdmin())
		{
			$input_data = $this->input->post();
            $input_data = $this->security->xss_clean($input_data);
			$search = $input_data['search'];

		    // $query = "SELECT * FROM inventory WHERE item_name like'%".$search."%'";
		    // $result = mysqli_query($con,$query);
		    $result=$this->db->like('f_name', $search)->get('food')->result_array();
		    
		    	foreach ($result as $row) {
		        $response[] = array("label"=>$row['f_name'].'-'.$row['size'],"f_price"=>$row['f_price'],"f_id"=>$row['f_id'],"unit"=>$row['unit']);
		    	}

		    echo json_encode($response);
		}
	}
	public function billing_save()
	{
		if(isAdmin())
		{
			$input_data = $this->input->post();
            $input_data = $this->security->xss_clean($input_data);
            $state_code = substr($input_data['gst'], 0, 2);
            
        	$insert_data['bill_no'] = $input_data['bill_no'];
        	$insert_data['cus_name'] = $input_data['cus_name'];
        	$insert_data['cus_phone'] = $input_data['cus_phone'];
        	$insert_data['cus_email'] = $input_data['cus_email'];
        	$insert_data['cus_address'] = $input_data['cus_address'];
        	$insert_data['delivery_mode'] = $input_data['delivery_mode'];
        	$insert_data['supply_reff'] = $input_data['supply_reff'];
        	$insert_data['oth_reff'] = $input_data['oth_reff'];
        	$insert_data['tax_type'] = $input_data['tax_type'];
        	$insert_data['gst'] = $input_data['gst'];
        	$insert_data['state'] = $input_data['state'];
        	$insert_data['city'] = $input_data['city'];
        	$insert_data['pin'] = $input_data['pin'];
        	$insert_data['dispath_documence'] = $input_data['dispath_documence'];
        	$insert_data['document_through'] = $input_data['document_through'];
        	$insert_data['delivery_note'] = $input_data['delivery_note'];
        	$insert_data['state_code'] = $state_code;
        	$insert_data['prd_type'] = 'Food';
            $this->db->insert('billing',$insert_data);
            $last_id=$this->db->insert_id();
            foreach ($input_data['itemName'] as $key => $rate_data) {
            	$insert_bill_data['billing_id'] = $last_id;
	        	$insert_bill_data['item_name'] = $input_data['itemName'][$key];
	        	$insert_bill_data['sl_no'] = $input_data['slno'][$key];
	        	$insert_bill_data['mrp'] = $input_data['price'][$key];
	        	$insert_bill_data['price'] = $input_data['price'][$key];
	        	$insert_bill_data['quantity'] = $input_data['qty'][$key];
	        	$insert_bill_data['unit'] = $input_data['unit'][$key];
	        	$insert_bill_data['description'] = '';
	            $this->db->insert('billing_data',$insert_bill_data);
            $q=$input_data['qty'][$key];
            }
		}
	}

}