<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class DoctorCategory extends CI_Controller {

	function __construct() 
	{
        error_reporting(0);
        parent::__construct();
        $this->load->model('CommonModel');
        $this->load->helper('Security');
        $this->load->library('form_validation');

       
    }

	public function index()
	{ 
		if(isAdmin())
		{ 
			$data['recordSet']=$this->db->get('doctor_category')->result_array();
			$data['content'] = 'DoctorCategory/Listing';
			$this->load->view('layout_home', $data);
		}
	}
	public function cat_edit_details()
	{ 
		if(isAdmin())
		{ 
			$input_data = $this->input->post();
            $input_data = $this->security->xss_clean($input_data);
			$cat_details=$this->db->where('dcat_id',$input_data['dcat_id'])->get('doctor_category')->result_array();
		?>
		<div class="row">
          <div class="form-group">
            <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12">
                <label>Category</label>
                <input type="text" name="dcat_name" id="dcat_name" class="form-control"  value="<?php echo $cat_details['0']['dcat_name']; ?>" required="" placeholder="Enter Category"><br>
                <input type="hidden" name="dcat_id" value="<?php echo $cat_details['0']['dcat_id']; ?>">
            </div>
          </div>
          </div>

		<?php
		}
	}

	public function add()
	{
		if(isAdmin())
		{
			$data['content'] = 'DoctorCategory/Add';
			$this->load->view('layout_home', $data);
		}
	}

	public function save()
	{
		if(isAdmin())
		{
			$input_data = $this->input->post();
            $input_data = $this->security->xss_clean($input_data);
            $duplicate_data=$this->db->where('dcat_name', $input_data['dcat_name'])->get('doctor_category')->result_array();
            if(empty($duplicate_data))
            {
            
        	$insert_data['dcat_name'] = $input_data['dcat_name'];
        	$insert_data['dcat_status'] = '1';
        	
            $this->db->insert('doctor_category',$insert_data);
            echo 'success';
        	} else{
        		echo 'failed';
        	}
		}
	}

	public function Edit_data()
	{
	    if(isAdmin())
	    {  
	        	$input_data = $this->input->post();
	            $input_data = $this->security->xss_clean($input_data);
	            $duplicate_data=$this->db->where('dcat_name', $input_data['dcat_name'])->where('dcat_id !=', $input_data['dcat_id'])->get('doctor_category')->result_array();
	            if(empty($duplicate_data))
	            {
	            $edit_data['dcat_name'] = $input_data['dcat_name'];
	        	
	            $this->db->where('dcat_id',$input_data['dcat_id']);
	            $this->db->update('doctor_category',$edit_data);
	            echo 'success';
	        	} else{
	        		echo 'failed';
	        	}
	    }      
	}
	public function status_change()
	{
	    if(isAdmin())
	    {  
	        	$input_data = $this->input->post();
	            $input_data = $this->security->xss_clean($input_data);
	            $edit_data['cat_status'] = $input_data['new_status'];
	        	
	            $this->db->where('cat_id',$input_data['id']);
	            $this->db->update('category',$edit_data);
	            echo 'success';
	    }      
	}
	public function Delete()
    {
        if(isAdmin())
        {
        	$input_data = $this->input->post();
        	$this->db->where('dcat_id', $input_data['id']);
			$this->db->delete('doctor_category');
        }
    }
    public function export()
	{
		if(isAdmin())
		{ 
			$project_array=$this->db->get('category')->result_array();
			header("Content-type: application/csv");
		    header("Content-Disposition: attachment; filename=\"category-".date('d-m-Y').".csv\"");
		    header("Pragma: no-cache");
		    header("Expires: 0");

		     $handle = fopen('php://output', 'w');
			$excel_heding=array();
			array_push($excel_heding, 'SL', 'Category Name', 'Status','Added Date');
			fputcsv($handle, $excel_heding);
			foreach ($project_array as $key => $project_data) {
			$export_req = array();
			if ($project_data['cat_status']=='1') {
			$status='Active';
			}
			else
			{
			$status='Inactive';
			}
			array_push($export_req, $key+1, $project_data['cat_name'], $status, $project_data['added_date']);

			//print_r($call_det);die;
			fputcsv($handle, $export_req);
			} 
			 fclose($handle);
		     exit;
		
		}
	}
	public function import(){

        $data = array();

        $memData = array();

                $insertCount = $updateCount = $rowCount = $notAddCount = 0;

                if(is_uploaded_file($_FILES['import_data']['tmp_name'])){

                    $this->load->library('CSVReader');

                    $csvData = $this->csvreader->parse_csv($_FILES['import_data']['tmp_name']);

                    if(!empty($csvData)){

                        foreach($csvData as $row){ 
                        	$rowCount++;
                        	$duplicate_data=$this->db->where('cat_name', $row['Category'])->get('category')->result_array();
				            if(empty($duplicate_data))
				            {
							$insert_data['cat_name'] = $row['Category'];
							
							$this->db->insert('category',$insert_data);	
							}

                          $insertCount++;  

                        }
                        $notAddCount = ($rowCount - ($insertCount + $updateCount));
                    }
                }

    }

}