<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Customer extends CI_Controller {

	function __construct() 
	{
        error_reporting(0);
        parent::__construct();
        $this->load->model('CommonModel');
        $this->load->helper('Security');
        $this->load->library('form_validation');

       
    }

	public function index()
	{ 
		if(isAdmin())
		{ 
			$data['recordSet']=$this->db->get('customer')->result_array();
			$data['content'] = 'Customer/Listing';
			$this->load->view('layout_home', $data);
		}
	}

	public function file_name($file_name)
	{ 
		if(isAdmin())
		{ 
			$data['recordSet']=$this->db->where('file_name',$file_name)->order_by('c_id','desc')->get('customer')->result_array();
			$data['content'] = 'Customer/Listing';
			$this->load->view('layout_home', $data);
		}
	}

	public function add()
	{
		if(isAdmin())
		{
			$data['category']=$this->db->where('cat_status', '1')->get('category')->result_array();
			$data['content'] = 'Customer/Add';
			$this->load->view('layout_home', $data);
		}
	}
	public function edit($para1)
	{
		if(isAdmin())
		{

			$data['category']=$this->db->where('cat_status', '1')->get('category')->result_array();
			$data['row']= $this->CommonModel->fetch_a_row('c_id',$para1,'customer');
            $data['content']  ="Customer/Edit";
            $this->load->view('layout_home',$data);
		}
	}

	public function save()
	{
		if(isAdmin())
		{
			$input_data = $this->input->post();
            $input_data = $this->security->xss_clean($input_data);

        	$insert_data['c_name'] = $input_data['c_name'];
        	$insert_data['c_mobile'] = $input_data['c_mobile'];
        	$insert_data['c_email'] = $input_data['c_email'];
        	$insert_data['c_address'] = $input_data['c_address'];
        	$insert_data['file_name'] = 'Manually Added';
        	$insert_data['c_category'] = $input_data['c_category'];
        	
            $this->db->insert('customer',$insert_data);
            echo 'success';
		}
	}

	public function Edit_data()
	{
	    if(isAdmin())
	    {  
	        	$input_data = $this->input->post();
	            $input_data = $this->security->xss_clean($input_data);

	            $edit_data['c_name'] = $input_data['c_name'];
	        	$edit_data['c_mobile'] = $input_data['c_mobile'];
	        	$edit_data['c_email'] = $input_data['c_email'];
	        	$edit_data['c_address'] = $input_data['c_address'];
	        	$edit_data['c_category'] = $input_data['c_category'];
	        	
	            $this->db->where('c_id',$input_data['c_id']);
	            $this->db->update('customer',$edit_data);
	            echo 'success';
	    }      
	}
	public function status_change()
	{
	    if(isAdmin())
	    {  
	        	$input_data = $this->input->post();
	            $input_data = $this->security->xss_clean($input_data);
	            $edit_data['status'] = $input_data['new_status'];
	        	
	            $this->db->where('employee_id',$input_data['id']);
	            $this->db->update('employee',$edit_data);
	            echo 'success';
	    }      
	}
	public function Delete()
    {
        if(isAdmin())
        {
        	$input_data = $this->input->post();
        	$this->db->where('c_id', $input_data['id']);
			$this->db->delete('customer');
             // / ---------------------------Insert Audit trail--------------------
            $audit_trail_table='audit_trail';
	        $audit_trail_array=array(
	                                    'user_name'=>$this->session->userdata('admin_name'),
	                                    'action'=>'Action -> "Delete Customer"',
	                                    'action_time'=>date('Y-m-d H:i:s')
	                                );
        	$this->CommonModel->insert($audit_trail_table,$audit_trail_array);
        }
    }

    public function export()
	{
		if(isAdmin())
		{ 
			$project_array=$this->db->get('customer')->result_array();
			header("Content-type: application/csv");
		    header("Content-Disposition: attachment; filename=\"Customer-".date('d-m-Y').".csv\"");
		    header("Pragma: no-cache");
		    header("Expires: 0");

		     $handle = fopen('php://output', 'w');
			$excel_heding=array();
			array_push($excel_heding, 'SL', 'Name', 'Mobile','Email ID', 'Address',  'Category',  'File Name');
			fputcsv($handle, $excel_heding);
			foreach ($project_array as $key => $project_data) {
			$category_data=$this->db->where('cat_id', $project_data['c_category'])->get('category')->result_array();
			$category = $category_data[0]['cat_name'];
			$export_req = array();
			array_push($export_req, $key+1, $project_data['c_name'], $project_data['c_mobile'], $project_data['c_email'], $project_data['c_address'], $category, $project_data['file_name']);

			//print_r($call_det);die;
			fputcsv($handle, $export_req);
			} 
			 fclose($handle);
		     exit;
		
		}
	}

	public function import(){

       // $data = array();

       //  $memData = array();

       //  $insertCount = $updateCount = $rowCount = $notAddCount = 0;

       //  if(is_uploaded_file($_FILES['import_data']['tmp_name'])){
       //  	echo 'hi';

       //      $this->load->library('CSVReader');

       //      $csvData = $this->csvreader->parse_csv($_FILES['import_data']['tmp_name']);
       //      // print_r($csvData); die;
       //      if(!empty($csvData)){
       //      	echo 'welcome';
       //          foreach($csvData as $row){ 
       //          	$rowCount++;
       //          	$category_data=$this->db->where('cat_name', $row['Category'])->get('category')->result_array();
	// 				$insert_data['c_name'] = $row['Name'];
	// 				$insert_data['c_mobile'] = $row['Mobile Number'];
	// 				$insert_data['c_address'] = $row['Address'];
	// 				$insert_data['c_category'] = $category_data[0]['cat_id'];
					
	// 				$this->db->insert('customer',$insert_data);	
										
					
       //            $insertCount++;  

       //          }
       //          $notAddCount = ($rowCount - ($insertCount + $updateCount));
       //      }
       //  }





        $input_data = $this->input->post();
            $input_data = $this->security->xss_clean($input_data);
            $this->load->library('Csvimport');

             $file_data = $this->csvimport->get_array($_FILES["import_data"]["tmp_name"]); 
             $i=1;     
            
             
             foreach($file_data as $row) 
             { 
             	$category_data=$this->db->where('cat_name', $row['Category'])->get('category')->result_array();
             	if (!empty($category_data)) {
             	
             	$employee_data=$this->db->where('employee_code', $row['Employee Code'])->get('employee')->result_array();
                $insert_data['c_name'] = $row['Name'];			
				$insert_data['c_mobile'] = $row['Mobile Number'];
				$insert_data['c_email'] = $row['Email ID'];
				$insert_data['c_address'] = $row['Address'];
				$insert_data['file_name'] = $row['File Name'];
				$insert_data['c_category'] = $category_data[0]['cat_id'];
				$this->db->insert('customer',$insert_data); 
				$customer_id=$this->db->insert_id();
				if (!empty($employee_data)) {
				
				$assign_data['c_id'] = $customer_id;			
				$assign_data['e_id'] = $employee_data[0]['e_id'];
				$assign_data['date'] = date('Y-m-d',strtotime($row['Date']));
				$assign_data['assign_date'] = date('Y-m-d H:i:s');
				$assign_data['status'] = 0;
				$this->db->insert('call_assign',$assign_data);  
				}
			}


             } 
             
            






    }
}