<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Attendance extends CI_Controller {

	function __construct() 
	{
        error_reporting(0);
        parent::__construct();
        $this->load->model('CommonModel');
        $this->load->helper('Security');
        $this->load->library('form_validation');

       
    }

	public function index()
	{ 
		if(isAdmin())
		{ 
			$data['recordSet']=$this->db->get('employee')->result_array();
			// $data['recordSet']=$this->db->get('attendance')->result_array();
			$data['content'] = 'Attendance/Listing';
			$this->load->view('layout_home', $data);
		}
	}

	public function details($id)
	{ 
		if(isAdmin())
		{ 
			$data['recordSet']=$this->db->get('employee')->result_array();
			 $data['recordSet']=$this->db->select('e.e_name,e.employee_code,a.out_time,a.in_time,a.date,a.e_id')->from('attendance as a')->join('employee as e', 'a.e_id = e.e_id', 'LEFT')->where('md5(a.e_id)',$id)->order_by('a_id','desc')->get()->result_array();;
			$data['content'] = 'Attendance/Details';
			$this->load->view('layout_home', $data);
		}
	}

	public function add()
	{
		if(isAdmin())
		{
			$data['content'] = 'Attendance/Add';
			$this->load->view('layout_home', $data);
		}
	}
	public function edit($para1)
	{
		if(isAdmin())
		{
			$data['row']= $this->CommonModel->fetch_a_row('a_id',$para1,'attendance');
            $data['content']  ="Attendance/Edit";
            $this->load->view('layout_home',$data);
		}
	}

	public function save()
	{
		if(isAdmin())
		{
			$input_data = $this->input->post();
            $input_data = $this->security->xss_clean($input_data);

            
        	$insert_data['e_id'] = $input_data['e_id'];
        	$insert_data['date'] = $input_data['date'];
        	$insert_data['in_time'] = $input_data['in_time'];
        	$insert_data['out_time'] = $input_data['out_time'];
            $this->db->insert('attendance',$insert_data);
            echo 'Success';
		}
	}

	public function Edit_data()
	{
	    if(isAdmin())
	    {  
	        	$input_data = $this->input->post();
	            $input_data = $this->security->xss_clean($input_data);
	            $edit_data['e_id'] = $input_data['e_id'];
	        	$edit_data['date'] = $input_data['date'];
	        	$edit_data['in_time'] = $input_data['in_time'];
	        	$edit_data['out_time'] = $input_data['out_time'];
	        	
	            $this->db->where('a_id',$input_data['a_id']);
	            $this->db->update('attendance',$edit_data);
	            echo 'Success';
	    }      
	}
	public function status_change()
	{
	    if(isAdmin())
	    {  
	    	$input_data = $this->input->post();
	            $input_data = $this->security->xss_clean($input_data);
	    	$attendance_data=$this->db->where('e_id',$input_data['id'])->where('date',date('Y-m-d'))->get('attendance')->result_array();
	    	if ($input_data['new_status']=='0') {
	    	
	    	if ($attendance_data) {
	    	
	        	
	            echo 'Alredy Submited';
	        }
	        else
	        {

	        	
	            
	        	$insert_data['e_id'] = $input_data['id'];
	        	$insert_data['date'] = date('Y-m-d');
	        	$insert_data['in_time'] = date('Y-m-d H:i:s');
	        	$insert_data['out_time'] ='';
	            $this->db->insert('attendance',$insert_data);
	        }
	    	}
	    	else
	    	{
	    		
	    	if ($attendance_data) {
	    	// if($attendance_data[0]['out_time']=='0000-00-00 00:00:00')
	    	// {
	    		
	        	$edit_data['out_time'] = date('Y-m-d H:i:s');
	        	
	            $this->db->where('e_id',$input_data['id']);
	            $this->db->where('date',date('Y-m-d'));
	            $this->db->update('attendance',$edit_data);
	    	// }
	    	// else
	    	// {
			//  echo 'Alredy Submited';
	    	// }
	        	
	           
	        }
	        else
	        {

	        	
	            
	        	$insert_data['e_id'] = $input_data['id'];
	        	$insert_data['date'] = date('Y-m-d');
	        	$insert_data['in_time'] = date('Y-m-d H:i:s');
	        	$insert_data['out_time'] =date('Y-m-d H:i:s');
	            $this->db->insert('attendance',$insert_data);
	        }
	    	}
	    }      
	}
	public function Delete()
    {
        if(isAdmin())
        {
        	$input_data = $this->input->post();
        	$this->db->where('a_id', $input_data['id']);
			$this->db->delete('attendance');
             // / ---------------------------Insert Audit trail--------------------
            $audit_trail_table='audit_trail';
	        $audit_trail_array=array(
	                                    'user_name'=>$this->session->userdata('admin_name'),
	                                    'action'=>'Action -> "Delete Attendance"',
	                                    'action_time'=>date('Y-m-d H:i:s')
	                                );
        	$this->CommonModel->insert($audit_trail_table,$audit_trail_array);
        }
    }

    public function export()
	{
		if(isAdmin())
		{ 
			$project_array=$this->db->get('attendance')->result_array();
			header("Content-type: application/csv");
		    header("Content-Disposition: attachment; filename=\"project-".date('d-m-Y').".csv\"");
		    header("Pragma: no-cache");
		    header("Expires: 0");

		     $handle = fopen('php://output', 'w');
			$excel_heding=array();
			array_push($excel_heding, 'SL', 'Attendance Code', 'Name', 'Email ID', 'Mobile', 'Address',  'Status','Join Date');
			fputcsv($handle, $excel_heding);
			foreach ($project_array as $key => $project_data) {
			$export_req = array();
			if ($project_data['e_status']=='1') {
			$status='Active';
			}
			else
			{
			$status='Inactive';
			}
			array_push($export_req, $key+1, $project_data['e_id'], $project_data['date'], $project_data['in_time'], $project_data['out_time']);

			//print_r($call_det);die;
			fputcsv($handle, $export_req);
			} 
			 fclose($handle);
		     exit;
		
		}
	}
	public function import(){

        $data = array();

        $memData = array();

                $insertCount = $updateCount = $rowCount = $notAddCount = 0;

                if(is_uploaded_file($_FILES['import_data']['tmp_name'])){

                    $this->load->library('CSVReader');

                    $csvData = $this->csvreader->parse_csv($_FILES['import_data']['tmp_name']);

                    if(!empty($csvData)){

                        foreach($csvData as $row){ 
                        	$rowCount++;
                        	
							$insert_data['e_id'] = $row['Employee Code'];
							$insert_data['date'] = $row['Name'];
							$insert_data['in_time'] = $row['Email ID'];
							$insert_data['out_time'] = $row['Mobile Number'];
							
							$this->db->insert('attendance',$insert_data);						
							
                          $insertCount++;  

                        }
                        $notAddCount = ($rowCount - ($insertCount + $updateCount));
                    }
                }

    }

}