<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class AdminDashboard extends CI_Controller {
public $somevar;
	function __construct() 
	{
       error_reporting(0);
        parent::__construct();
        $this->load->model('AdminModel');
       
    }

	public function index()
	{
		if(isAdmin())
		{   
			$data['total_customers'] = $this->AdminModel->get_total_customers();
	        $data['total_bookings']  = $this->AdminModel->get_total_bookings();
	        $data['total_revenue']   = $this->AdminModel->get_total_revenue();
	        $data['active_sports']   = $this->AdminModel->get_active_sports();

	        $data['recent_bookings'] = $this->AdminModel->get_recent_bookings(5);

	        // Chart data
	        $data['monthly_bookings'] = $this->AdminModel->get_monthly_bookings();
	        $data['sports_popularity'] = $this->AdminModel->get_sports_popularity();

			$data['content'] = 'AdminDashboard/index';
			$this->load->view('layout_home', $data);
		}
	}

	
	public function rooms()
	{ 
		if(isAdmin())
		{ 
			$data['recordSet']=$this->db->select('rn.room_number,rn.r_id,r.r_type,r.r_price')->from('room_numbers as rn')->join('rooms as r', 'rn.r_id = r.r_id', 'LEFT')->where('rn.room_status','Available')->get()->result_array();
			$data['content'] = 'AdminDashboard/Rooms';
			$this->load->view('layout_home', $data);
		}
	}
	public function payment_receive()
	{ 
		if(isAdmin())
		{ 
			
			$data['content'] = 'AdminDashboard/Payment_receive';
			$this->load->view('layout_home', $data);
		}
	}
	public function cash_receive_refund()
	{ 
		if(isAdmin())
		{ 
			
			$data['content'] = 'AdminDashboard/cash_receive_refund';
			$this->load->view('layout_home', $data);
		}
	}
	public function advance_receive()
	{ 
		if(isAdmin())
		{ 
			
			$data['content'] = 'AdminDashboard/advance_receive';
			$this->load->view('layout_home', $data);
		}
	}
	public function checkout_receive()
	{ 
		if(isAdmin())
		{ 
			
			$data['content'] = 'AdminDashboard/checkout_receive';
			$this->load->view('layout_home', $data);
		}
	}
	public function due_amount()
	{ 
		if(isAdmin())
		{ 
			
			$data['content'] = 'AdminDashboard/due_amount';
			$this->load->view('layout_home', $data);
		}
	}
	public function refundable_amount()
	{ 
		if(isAdmin())
		{ 
			
			$data['content'] = 'AdminDashboard/refundable_amount';
			$this->load->view('layout_home', $data);
		}
	}
	public function todays_booking()
	{ 
		if(isAdmin())
		{ 
			
			$data['recordSet']=$this->db->like('booking_date',date('Y-m-d'),'after')->order_by("wr_id", "desc")->get('walk_in_reservation')->result_array();
			$data['content'] = 'AdminDashboard/todays_booking';
			$this->load->view('layout_home', $data);


		}
	}
	public function total_occupency()
	{ 
		if(isAdmin())
		{ 
			
			$data['recordSet']=$this->db->where('room_available',0)->order_by("wr_id", "desc")->get('walk_in_reservation')->result_array();
			$data['content'] = 'AdminDashboard/total_occupency';
			$this->load->view('layout_home', $data);


		}
	}
	public function today_check_in()
	{ 
		if(isAdmin())
		{ 
			
			$data['recordSet']=$this->db->like('check_in',date('Y-m-d'))->where('room_available',0)->order_by("wr_id", "desc")->get('walk_in_reservation')->result_array();
			$data['content'] = 'AdminDashboard/today_check_in';
			$this->load->view('layout_home', $data);


		}
	}
	public function today_check_out()
	{ 
		if(isAdmin())
		{ 
			
			$data['recordSet']=$this->db->like('check_out',date('Y-m-d'))->where('room_available',1)->order_by("wr_id", "desc")->get('walk_in_reservation')->result_array();
			$data['content'] = 'AdminDashboard/today_check_out';
			$this->load->view('layout_home', $data);


		}
	}
}
