<!-- Breadcrumb -->
			<section class="breadcrumb breadcrumb-list mb-0">
				<span class="primary-right-round"></span>
				<div class="container">
					<h1 class="text-white">Booking History</h1>
					<ul>
						<li><a href="<?php echo base_url(); ?>">Home</a></li>
						<li>User Bookings</li>
					</ul>
				</div>
			</section>
			<!-- /Breadcrumb -->
			<!-- Dashboard Menu -->
			<div class="dashboard-section">
				<div class="container">
					<div class="row">
						<div class="col-lg-12">
							<div class="dashboard-menu">
								<ul>
									<li>
										<a href="<?php echo base_url(); ?>booking/history/" class="active">
											<img src="<?php echo base_url(); ?>assets/img/icons/booking-icon.svg" alt="Icon">
											<span>My Bookings</span>
										</a>
									</li>
									<li>
										<a href="<?php echo base_url(); ?>profile/">
											<img src="<?php echo base_url(); ?>assets/img/icons/profile-icon.svg" alt="Icon">
											<span>Profile Setting</span>
										</a>
									</li>
								</ul>
							</div>
						</div>
					</div>
				</div>
			</div>
			<!-- /Dashboard Menu -->
			<!-- Page Content -->
			<div class="content court-bg">
				<div class="container">
					<div class="row">
						<div class="col-sm-12">
							<div class="court-tab-content">
								<div class="card card-tableset">
									<div class="card-body">
										<div class="coache-head-blk">
											<div class="row align-items-center">
												<div class="col-md-5">
													<div class="court-table-head">
														<h4>My Bookings</h4>
														<p>Manage and track all your upcoming court bookings.</p>
													</div>
												</div>
											</div>
										</div>
										<div class="tab-content">
											<div class="tab-pane fade show active" id="nav-Recent" role="tabpanel" aria-labelledby="nav-Recent-tab"
												tabindex="0">
												<div class="table-responsive table-datatble">
													<table class="table table-striped datatable">
													    <thead class="thead-light">
													        <tr>
													            <th>Game Name</th>
													            <th>Date & Time</th>
													            <th>Payment</th>
													            <th>Status</th>
													            <th>Action</th>
													        </tr>
													    </thead>
													    <tbody>
													        <?php if(!empty($bookings)): ?>
													            <?php foreach($bookings as $b): ?>
													                <tr>
													                    <td>
													                        <h2 class="table-avatar d-flex align-items-center">
													                            <a href="#" class="avatar avatar-sm flex-shrink-0 me-2">
													                                <img class="avatar-img" src="<?php echo base_url().'uploads/game/thumbnail/'.$b->sport_image; ?>" alt="Game">
													                            </a>
													                            <span class="table-head-name flex-grow-1">
													                                <a href="#"><?= $b->sport_name ?></a>
													                                <span><?= $b->pitch_name ?></span>
													                            </span>
													                        </h2>
													                    </td>
													                    <td class="table-date-time">
													                        <h4>
													                            <?= date("D, M d", strtotime($b->booking_date)) ?>
													                            <span><?= date("h:i A", strtotime($b->start_time)) ?> - <?= date("h:i A", strtotime($b->end_time)) ?></span>
													                        </h4>
													                    </td>
													                    <td><span class="pay-dark fs-6">₹<?= $b->total_price ?></span></td>
													                    <td>
													                        <?php if($b->status == "confirmed"): ?>
													                            <span class="badge bg-success"><i class="feather-check-square me-1"></i>Accepted</span>
													                        <?php elseif($b->status == "pending"): ?>
													                            <span class="badge bg-info"><i class="feather-clock me-1"></i>Awaiting</span>
													                        <?php elseif($b->status == "cancelled"): ?>
													                            <span class="badge bg-danger"><i class="feather-x-square me-1"></i>Cancelled</span>
													                        <?php else: ?>
													                            <span class="badge bg-secondary"><?= ucfirst($b->status) ?></span>
													                        <?php endif; ?>
													                    </td>
													                    <td class="text-pink view-detail-pink">
													                        <?php if($b->status == "confirmed" || $b->status == "pending"): ?>
													                            <a href="javascript:;" data-bs-toggle="modal" data-bs-target="#cancelModal<?= $b->id ?>">Cancel Booking</a>
													                            
													                            <!-- Cancel Modal -->
													                            <div class="modal fade" id="cancelModal<?= $b->id ?>" tabindex="-1">
													                                <div class="modal-dialog">
													                                    <div class="modal-content">
													                                        <div class="modal-header">
													                                            <h5 class="modal-title">Cancel Booking</h5>
													                                            <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
													                                        </div>
													                                        <div class="modal-body">
													                                            <p>Are you sure you want to cancel booking for <b><?= $b->sport_name ?> - <?= $b->pitch_name ?></b> on <?= date("D, M d Y", strtotime($b->booking_date)) ?> at <?= date("h:i A", strtotime($b->start_time)) ?>?</p>
													                                        </div>
													                                        <div class="modal-footer">
													                                            <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
													                                            <a href="<?= site_url('booking/cancel/'.$b->id) ?>" class="btn btn-danger">Yes, Cancel</a>
													                                        </div>
													                                    </div>
													                                </div>
													                            </div>
													                        <?php endif; ?>
													                    </td>
													                </tr>
													            <?php endforeach; ?>
													        <?php else: ?>
													            <tr><td colspan="5" class="text-center">No bookings found.</td></tr>
													        <?php endif; ?>
													    </tbody>
													</table>
												</div>
											</div>
										</div>
										
									</div>
								</div>
							</div>
						</div>
					</div>
				</div>
			</div>
			<!-- /Page Content -->