<!-- <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet"> -->
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <style>
        .slot { padding:10px 15px; margin:5px; border-radius:5px; cursor:pointer; display:inline-block; }
        .available { background:#d4edda; }
        .booked { background:#f8d7da; cursor:not-allowed; }
        .selected { background:#0d6efd; color:#fff; }
    </style>
<!-- Breadcrumb -->
        <div class="breadcrumb breadcrumb-list mb-0">
            <span class="primary-right-round"></span>
            <div class="container">
                <h1 class="text-white">Book Your Game</h1>
                <ul>
                    <li><a href="<?php echo base_url(); ?>">Home</a></li>
                    <li><a href="<?php echo base_url(); ?>booking/">Booking</a></li>
                    <li>Booking Confirm</li>
                </ul>
            </div>
        </div>
        <!-- /Breadcrumb -->
        


  <script src="https://cdn.tailwindcss.com"></script>
  <style>
    /* Custom scroll for calendar dates container */
    .scrollbar-hide::-webkit-scrollbar {
      display: none;
    }
    .scrollbar-hide {
      -ms-overflow-style: none;
      scrollbar-width: none;
    }
    .slot-button {
      transition: background-color 0.3s, color 0.3s;
    }
    .slot-button.available:hover {
      background-color: #34d399; /* green-400 */
      color: white;
    }
    .slot-button.selected {
      background-color: #059669; /* green-700 */
      color: white;
    }
    .slot-button.unavailable {
      background-color: #ef4444; /* red-500 */
      color: white;
      cursor: not-allowed;
    }
    .modal-overlay {
      background-color: rgba(0,0,0,0.5);
    }
    .booksec{
        padding: 50px 0;
    }

    .text-d-green{
        color: #234015;
    }
    .mdlentim{
        top: 40%;
        left: 30%;
    }
  </style>
<div class="booksec">
    <div class="container">
        <div class="row">
            <div class="col-md-1"></div>
            <div class="col-md-10">
              <!-- Address Section -->
             <form id="bookingForm" method="post" action="<?php echo base_url(); ?>booking/save_booking/"> 
              <section class="w-full bg-white p-6 rounded-lg shadow-md mb-8">
               <div class="container mt-5">
                  <div class="row">
                    <!-- Left: Billing / Booking Form -->
                  
                    <div class="col-md-7">
                      <h3 class="text-lg font-semibold mb-2 text-gray-900">Billing Details</h3>
                        <div class="row g-3">
                          <div class="col-md-6">
                            <label class="form-label">Name *</label>
                            <input type="text" name="name" class="form-control" value="<?= $customer ? $customer->name : '' ?>" required>
                          </div>
                          <div class="col-md-6">
                            <label class="form-label">Phone *</label>
                            <input type="text" name="phone" class="form-control" value="<?= $customer ? $customer->mobile : '' ?>" required>
                          </div>
                          <div class="col-md-12">
                            <label class="form-label">Email *</label>
                            <input type="email" name="email" class="form-control" value="<?= $customer ? $customer->email : '' ?>" required>
                          </div>
                          <div class="col-12">
                            <label class="form-label">Address *</label>
                            <textarea name="address" rows="2" class="form-control" required><?= $customer ? $customer->address : '' ?></textarea>
                          </div>
                        </div>
                    </div>
                    <?php  
                    $sports = $this->db->where('id', $pitch->sport_id)->get('sports')->result_array();
                    ?>
                    <!-- Right: Booking Summary -->
                    <div class="col-md-5">
                      <div class="card shadow-sm p-3">
                        <h3 class="text-lg font-semibold mb-2 text-gray-900">Booking Summary</h3>
                        <ul class="list-group mb-3">
                          <li class="list-group-item d-flex justify-content-between">
                            <span>Game</span> <strong id="summary_game"><?php echo $sports[0]['name']; ?></strong>
                          </li>
                          <li class="list-group-item d-flex justify-content-between">
                            <span>Pitch</span> <strong id="summary_pitch"><?= $pitch->name ?></strong>
                          </li>
                          <li class="list-group-item d-flex justify-content-between">
                            <span>Date</span> <strong id="summary_date"><?= $booking_date ?></strong>
                          </li>
                          <li class="list-group-item d-flex justify-content-between">
                            <span>Time</span> <strong id="summary_time"><?= date('h:i A', strtotime($start_time)) ?> - <?= date('h:i A', strtotime($end_time)) ?></strong>
                          </li>
                          <li class="list-group-item d-flex justify-content-between">
                            <span>Price</span> <strong id="summary_price">₹<?= $total_price ?></strong>
                          </li>
                          <li class="list-group-item d-flex justify-content-between">
                            <span>Total</span> <strong id="summary_total">₹<?= $total_price ?></strong>
                          </li>
                        </ul>

                        <h6 class="mb-2">Payment Method</h6>
                        <div class="form-check mb-2">
                          <input class="form-check-input" type="radio" name="payment" id="cod" value="cod" checked>
                          <label class="form-check-label" for="cod">Pay on Cash</label>
                        </div>
                        <div class="form-check mb-4">
                          <input class="form-check-input" type="radio" name="payment" id="online" value="online">
                          <label class="form-check-label" for="online">Pay Online</label>
                        </div>

                        <button type="submit" form="bookingForm" class="btn btn-primary w-100">
                          Confirm & Pay
                        </button>
                        <input type="hidden" name="pitch_id" value="<?= $pitch->id ?>">
                        <input type="hidden" name="booking_date" value="<?= $booking_date ?>">
                        <input type="hidden" name="start_time" value="<?php echo $start_time; ?>">
                        <input type="hidden" name="end_time" value="<?php echo $end_time; ?>">
                        <input type="hidden" name="total_price" value="<?= $total_price ?>">
                      </div>
                    </div>
                  </div>
                </div>


  </section>
   </form>
</div>
</div>
</div>
</div>