<!-- <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet"> -->
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <style>
        .slot { padding:8px 25px; margin:5px; border-radius:5px; cursor:pointer; display:inline-block; }
        .available { background: #dcfce7;
    color: #198754; }
        .booked { background:red; color:#fff; cursor:not-allowed; }
        .selected { background:#198754; color:#fff; }
    </style>
<!-- Breadcrumb -->
        <div class="breadcrumb breadcrumb-list mb-0">
            <span class="primary-right-round"></span>
            <div class="container">
                <h1 class="text-white">Book Your Game</h1>
                <ul>
                    <li><a href="<?php echo base_url(); ?>">Home</a></li>
                    <li>Game</li>
                </ul>
            </div>
        </div>
        <!-- /Breadcrumb -->
        


  <script src="https://cdn.tailwindcss.com"></script>
  <style>
    /* Custom scroll for calendar dates container */
    .scrollbar-hide::-webkit-scrollbar {
      display: none;
    }
    .scrollbar-hide {
      -ms-overflow-style: none;
      scrollbar-width: none;
    }
    .slot-button {
      transition: background-color 0.3s, color 0.3s;
    }
    .slot-button.available:hover {
      background-color: #34d399; /* green-400 */
      color: white;
    }
    .slot-button.selected {
      background-color: #059669; /* green-700 */
      color: white;
    }
    .slot-button.unavailable {
      background-color: #ef4444; /* red-500 */
      color: white;
      cursor: not-allowed;
    }
    .modal-overlay {
      background-color: rgba(0,0,0,0.5);
    }
    .booksec{
        padding: 50px 0;
    }

    .text-d-green{
        color: #234015;
    }
    .mdlentim{
        top: 40%;
        left: 30%;
    }
    .btn-outline-success{
            padding: 8px 30px;
    font-weight: 500;
    border-radius: 6px;
    margin-right: 8px;
    }
  </style>
<div class="booksec">
    <div class="container">
        <div class="row">
            <div class="col-md-1"></div>
            <div class="col-md-10">
  <!-- Top Image -->
  <section class="w-full rounded-lg overflow-hidden shadow-lg mb-6">
    <img 
      src="<?php echo base_url(); ?>assets/img/cri.jpg" alt="" class="w-full h-auto object-cover" onerror="this.style.display='none'"
    />
  </section>

  <!-- Address Section -->
  <section class="w-full bg-white p-6 rounded-lg shadow-md mb-8">
    <div class="flex flex-col space-y-2">
      <h2 class="font-bold text-2xl text-gray-900">Top Turf Arena</h2>
      <p class="text-gray-700 flex items-center space-x-2">
        <svg xmlns="http://www.w3.org/2000/svg" class="h-5 w-5 text-d-green" fill="none" viewBox="0 0 24 24" stroke="currentColor" stroke-width="2" aria-hidden="true"><path stroke-linecap="round" stroke-linejoin="round" d="M12 11c1.657 0 3-1.343 3-3S13.657 5 12 5 9 6.343 9 8s1.343 3 3 3z" /><path stroke-linecap="round" stroke-linejoin="round" d="M12 22s8-4.5 8-10a8 8 0 1 0-16 0c0 5.5 8 10 8 10z" /></svg>
        <span>35/4A, Topsia Rd, Panchanna Pally, Topsia, Kolkata, West Bengal 700039</span>
      </p>
      <p class="text-gray-700 flex items-center space-x-2">
        <svg xmlns="http://www.w3.org/2000/svg" class="h-5 w-5 text-d-green" fill="none" viewBox="0 0 24 24" stroke="currentColor" stroke-width="2" aria-hidden="true"><circle cx="12" cy="12" r="10" /><path stroke-linecap="round" stroke-linejoin="round" d="M12 6v6l4 2" /></svg>
        <span>12:00 AM to 11:59 PM</span>
      </p>
      <small class="text-orange-500 font-semibold mt-2">100+ teams booked online recently</small>
    </div>
  </section>

<section class="w-full bg-white p-6 rounded-lg shadow-md mb-8">
  <h3 class="text-lg font-semibold mb-2 text-gray-900">Book Your Slot</h3>

<div class="row mb-3">
    <div class="col-md-4">
        <label>Select Date</label>
        <input type="text" id="booking_date" class="form-control" value="<?= $today ?>">
    </div>
</div>
</section>

<div class="row">
    <div class="col-md-6">
        <section class="w-full bg-white p-6 rounded-lg shadow-md mb-8">
        <div class="mb-3">
            <h3 class="text-lg font-semibold mb-2 text-gray-900">Select Sport</h3>
            <?php foreach($sports as $s): ?>
                <button class="btn btn-outline-success sport-btn <?= ($s->id==$default_sport)?'active':'' ?>" data-id="<?= $s->id ?>"><?= $s->name ?></button>
            <?php endforeach; ?>
        </div>
        </section>
    </div>
    <div class="col-md-6">
        <section class="w-full bg-white p-6 rounded-lg shadow-md mb-8">
            <div id="pitch_area" class="mb-3"></div>
        </section>
    </div>
</div>

        <section class="w-full bg-white p-6 rounded-lg shadow-md mb-8">
        <div id="slots_area" class="mb-3"></div>
        </section>
<div id="confirm_area" class="card p-3 d-none"></div>
</div>
</div>
</div>
</div>
<script>
let selectedSport = <?= $default_sport ?>;
let selectedPitch = <?= $default_pitch ?>;
let selectedSlot = null;
let slotPrice = 0;

$(document).ready(function(){
    loadPitches(selectedSport, selectedPitch);
    loadSlots();
});

$(".sport-btn").click(function(){
    $(".sport-btn").removeClass("active");
    $(this).addClass("active");
    selectedSport = $(this).data("id");
    loadPitches(selectedSport);
});

function loadPitches(sport_id, preselect=null){
    $.get("<?= site_url('booking/get_pitches/') ?>" + sport_id, function(res){
        let data = JSON.parse(res);
        let html = "<h3 class='text-lg font-semibold mb-2 text-gray-900'>Select Pitch</h3>";
        data.forEach((p,i)=>{
            let active = (preselect && p.id==preselect) || (!preselect && i==0);
            if(active) selectedPitch = p.id;
            html += `<button class="btn btn-outline-success pitch-btn ${active?'active':''}" data-id="${p.id}">${p.name}</button> `;
        });
        $("#pitch_area").html(html);
        loadSlots();
    });
}

$(document).on("click",".pitch-btn",function(){
    $(".pitch-btn").removeClass("active");
    $(this).addClass("active");
    selectedPitch = $(this).data("id");
    loadSlots();
});

$("#booking_date").change(function(){ loadSlots(); });

function loadSlots(){
    $.post("<?= site_url('booking/get_slots') ?>",{
        pitch_id:selectedPitch,
        date:$("#booking_date").val()
    },function(res){
        let data = JSON.parse(res);
        let html = "<h3 class='text-lg font-semibold mb-2 text-gray-900'>Available Slots</h3>";
        data.forEach(s=>{
            let cls = s.is_booked ? "slot booked" : "slot available";
            html += `<span class="${cls}" data-start="${s.start}" data-end="${s.end}">${s.display}</span>`;
        });
        $("#slots_area").html(html);
    });
}

$(document).on("click",".slot.available",function(){
    $(".slot").removeClass("selected");
    $(this).addClass("selected");

    selectedSlot = {
        start: $(this).data("start"),
        end: $(this).data("end"),
        display: $(this).text()
    };

    // fetch price
    $.post("<?= site_url('booking/get_price') ?>",{
        pitch_id:selectedPitch,
        date:$("#booking_date").val(),
        start_time:selectedSlot.start,
        end_time:selectedSlot.end
    },function(res){
        let data = JSON.parse(res);
        slotPrice = data.price;
        showConfirm();
    });
});

function showConfirm(){
    let bookingUrl = "<?= site_url('booking/booking_confirm') ?>?"
        + "pitch_id=" + selectedPitch
        + "&date=" + $("#booking_date").val()
        + "&start=" + selectedSlot.start
        + "&end=" + selectedSlot.end
        + "&price=" + slotPrice;
    $("#confirm_area").removeClass("d-none").html(`
        <h3 class='text-lg font-semibold mb-2 text-gray-900'>Booking Details</h3>
        <div class='space-y-3 mb-6'>
        <p><strong>Date:</strong> ${$("#booking_date").val()}</p>
        <p><strong>Time:</strong> ${selectedSlot.display} - ${selectedSlot.end}</p>
        <p><strong>Price:</strong> ₹${slotPrice}</p>
        </div>
        <a href="${bookingUrl}" id="confirm_btn" class="btn btn-success">Submit Booking</a>
    `);
}

// $(document).on("click","#confirm_btn",function(){
//     $.post("<?= site_url('booking/confirm') ?>",{
//         pitch_id:selectedPitch,
//         booking_date:$("#booking_date").val(),
//         start_time:selectedSlot.start,
//         end_time:selectedSlot.end,
//         total_price:slotPrice,
//         user_name:$("#user_name").val(),
//         user_mobile:$("#user_mobile").val()
//     },function(res){
//         let data = JSON.parse(res);
//         alert(data.message);
//         loadSlots();
//         $("#confirm_area").addClass("d-none");
//     });
// });
</script>