jQuery(document).ready(function(){
    
  var objGrid = jQuery("#{{uc_id}}");
  var inputCountSelector = ".uc-grid-count-buttons__number";
  //start count buttons	
  {% if show_count_buttons == "true" %}
  
  	var itemSelector = ".uc_post_grid_style_one_item";
   	var addToCartSelector = ".add_to_cart_button";
   	
   	var minusButtonSelector = ".uc-grid-count-buttons__minus";
    var plusButtonSelector = ".uc-grid-count-buttons__plus";
  
    var objInputs = objGrid.find(inputCountSelector);
  	var parentItem, g_countQuantity, objCountInput, objAddToCartBtn, objMinusBtn;  
  
    // finds related elements of the parent item
   	function findElements(buttonElement){
      
      	parentItem = buttonElement.parents(itemSelector);
      
    	objCountInput = parentItem.find(inputCountSelector);
      
        objAddToCartBtn = parentItem.find(addToCartSelector);      
        objMinusBtn = parentItem.find(minusButtonSelector);
        
        g_countQuantity = parseInt(objCountInput.val());
      
    }

    // define count functions
    function plusItem(buttonElement){
        
      	findElements(buttonElement);
      
		g_countQuantity++;
      
        objCountInput.val(g_countQuantity);
        objAddToCartBtn.attr('data-quantity', g_countQuantity); 
        
        objMinusBtn.prop('disabled', false); 
      
    } 

    function minusItem(buttonElement){
      
      	findElements(buttonElement);
      
		g_countQuantity--;
      
        if(g_countQuantity <= 0)
        return(true);
      
        objCountInput.val(g_countQuantity); 
        objAddToCartBtn.attr('data-quantity', g_countQuantity);

        if(g_countQuantity <= 1)
        objMinusBtn.prop('disabled', true);
      
    }
   
   /**
    * on quantity input change
    */
    function onQuantityInputChange(inputElement){
      
      findElements(inputElement);
		
      //get custom value
      g_countQuantity = parseInt(objCountInput.val());

      //update data-quantity attribute
      objAddToCartBtn.attr('data-quantity', g_countQuantity); 

      //enable click on minus button
      objMinusBtn.prop('disabled', false); 

      if(g_countQuantity <= 1){
        
        objMinusBtn.prop('disabled', true);
      	g_countQuantity = 1;
        
        //update data-quantity attribute
      	objAddToCartBtn.attr('data-quantity', g_countQuantity); 
        
        inputElement.val(g_countQuantity);
        
      }      

    }
  
    jQuery("body").on("added_to_cart", function(event, arg, arg2, objButton){
      
        findElements(objButton);
      
      	g_countQuantity = 1;
      
      	//update data-quantity attribute
      	objAddToCartBtn.attr('data-quantity', g_countQuantity); 
      
        objCountInput.val(1); 
            
  	});
  
    //init inputs  
    
  	objInputs.val(1);
  
    objGrid.on('click', plusButtonSelector, function(){
   		plusItem(jQuery(this));
    });
    
    objGrid.on('click', minusButtonSelector, function(){
   	    minusItem(jQuery(this));
    });
    
    objInputs.on('input', function(){
   	   onQuantityInputChange(jQuery(this));
    });
   
  objGrid.on('uc_ajax_refreshed', function(){  
        
    //find new inputs after items refresh
    objInputs = objGrid.find(inputCountSelector);
    
    //add event listener at new items after ajax refresh
    objInputs.on('input', function(){
   	   onQuantityInputChange(jQuery(this));
    });
    
  });
   
  {% endif %} 
  //end count buttons

    {% if redirect_to_checkout == "true" %}
      jQuery('#{{uc_id}} .uc-button-addcart').click(function(e) {

        var ueAddCartButton = jQuery(this);

        function checkAndRedirect(tryCount) {
          if (ueAddCartButton.hasClass('added')) {
            {% if redirect_to_checkout_open_in_new_tab == "false" %} window.location.href = "{{checkout_page_link}}"; {% endif %}
            {% if redirect_to_checkout_open_in_new_tab == "true" %} window.open("{{checkout_page_link}}", '_blank'); {% endif %}
          } else if (tryCount < 100) {
             setTimeout(function() {
             checkAndRedirect(tryCount + 1);
             }, 150);
          }
        }
                                                                                                                           
        checkAndRedirect(0);
                                                                                                                           
      });
  {% endif %}
  
   var objRemoteOptions = {
      class_items:"uc_post_grid_style_one_item",
      class_active:"ue-active-item",
      selector_item_trigger:null,
	  add_set_active_code:true,
    }; 	

    {{ucfunc("put_remote_parent_js","objGrid","objRemoteOptions")}}  
 
});